/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

public final class TrustAllTrustManager
implements X509TrustManager,
Serializable {
    private static final long serialVersionUID = -1295254056169520318L;
    private final boolean examineValidityDates;

    public TrustAllTrustManager() {
        this.examineValidityDates = false;
    }

    public TrustAllTrustManager(boolean bl) {
        this.examineValidityDates = bl;
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.examineValidityDates) {
            Date date = new Date();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                x509Certificate.checkValidity(date);
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.examineValidityDates) {
            Date date = new Date();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                x509Certificate.checkValidity(date);
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

