/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public abstract class WrapperKeyManager
extends X509ExtendedKeyManager {
    private final String certificateAlias;
    private final X509KeyManager[] keyManagers;

    protected WrapperKeyManager(KeyManager[] keyManagerArray, String string) {
        this.certificateAlias = string;
        this.keyManagers = new X509KeyManager[keyManagerArray.length];
        for (int i = 0; i < keyManagerArray.length; ++i) {
            this.keyManagers[i] = (X509KeyManager)keyManagerArray[i];
        }
    }

    protected WrapperKeyManager(X509KeyManager[] x509KeyManagerArray, String string) {
        this.keyManagers = x509KeyManagerArray;
        this.certificateAlias = string;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public final synchronized String[] getClientAliases(String string, Principal[] principalArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String[] stringArray = x509KeyManager.getClientAliases(string, principalArray);
            if (stringArray == null) continue;
            linkedHashSet.addAll(Arrays.asList(stringArray));
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[linkedHashSet.size()];
        return (String[])linkedHashSet.toArray(objectArray);
    }

    public final synchronized String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager x509KeyManager : this.keyManagers) {
                String string = x509KeyManager.chooseClientAlias(stringArray, principalArray, socket);
                if (string == null) continue;
                return string;
            }
            return null;
        }
        for (String string : stringArray) {
            for (X509KeyManager x509KeyManager : this.keyManagers) {
                String[] stringArray2 = x509KeyManager.getClientAliases(string, principalArray);
                if (stringArray2 == null) continue;
                for (String string2 : stringArray2) {
                    if (!string2.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    public final synchronized String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager x509KeyManager : this.keyManagers) {
                Object object;
                if (x509KeyManager instanceof X509ExtendedKeyManager) {
                    object = (X509ExtendedKeyManager)x509KeyManager;
                    String string = ((X509ExtendedKeyManager)object).chooseEngineClientAlias(stringArray, principalArray, sSLEngine);
                    if (string == null) continue;
                    return string;
                }
                object = x509KeyManager.chooseClientAlias(stringArray, principalArray, null);
                if (object == null) continue;
                return object;
            }
            return null;
        }
        for (String string : stringArray) {
            for (X509KeyManager x509KeyManager : this.keyManagers) {
                String[] stringArray2 = x509KeyManager.getClientAliases(string, principalArray);
                if (stringArray2 == null) continue;
                for (String string2 : stringArray2) {
                    if (!string2.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    public final synchronized String[] getServerAliases(String string, Principal[] principalArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String[] stringArray = x509KeyManager.getServerAliases(string, principalArray);
            if (stringArray == null) continue;
            linkedHashSet.addAll(Arrays.asList(stringArray));
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[linkedHashSet.size()];
        return (String[])linkedHashSet.toArray(objectArray);
    }

    public final synchronized String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager x509KeyManager : this.keyManagers) {
                String string2 = x509KeyManager.chooseServerAlias(string, principalArray, socket);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String[] stringArray = x509KeyManager.getServerAliases(string, principalArray);
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                if (!string3.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    public final synchronized String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager x509KeyManager : this.keyManagers) {
                Object object;
                if (x509KeyManager instanceof X509ExtendedKeyManager) {
                    object = (X509ExtendedKeyManager)x509KeyManager;
                    String string2 = ((X509ExtendedKeyManager)object).chooseEngineServerAlias(string, principalArray, sSLEngine);
                    if (string2 == null) continue;
                    return string2;
                }
                object = x509KeyManager.chooseServerAlias(string, principalArray, null);
                if (object == null) continue;
                return object;
            }
            return null;
        }
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            String[] stringArray = x509KeyManager.getServerAliases(string, principalArray);
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                if (!string3.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    public final synchronized X509Certificate[] getCertificateChain(String string) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            X509Certificate[] x509CertificateArray = x509KeyManager.getCertificateChain(string);
            if (x509CertificateArray == null) continue;
            return x509CertificateArray;
        }
        return null;
    }

    public final synchronized PrivateKey getPrivateKey(String string) {
        for (X509KeyManager x509KeyManager : this.keyManagers) {
            PrivateKey privateKey = x509KeyManager.getPrivateKey(string);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }
}

