/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1Enumerated
extends ASN1Element {
    private static final long serialVersionUID = -5915912036130847725L;
    private final int intValue;
    private final byte[] encodedValue;

    public ASN1Enumerated(int intValue) {
        super((byte)10);
        this.intValue = intValue;
        this.encodedValue = ASN1Integer.encodeIntValue(intValue);
    }

    public ASN1Enumerated(byte type, int intValue) {
        super(type);
        this.intValue = intValue;
        this.encodedValue = ASN1Integer.encodeIntValue(intValue);
    }

    private ASN1Enumerated(byte type, int intValue, byte[] value) {
        super(type, value);
        this.intValue = intValue;
        this.encodedValue = value;
    }

    public int intValue() {
        return this.intValue;
    }

    public byte[] getValue() {
        return this.encodedValue;
    }

    public byte[] encode() {
        switch (this.encodedValue.length) {
            case 1: {
                return new byte[]{this.getType(), 1, this.encodedValue[0]};
            }
            case 2: {
                return new byte[]{this.getType(), 2, this.encodedValue[0], this.encodedValue[1]};
            }
            case 3: {
                return new byte[]{this.getType(), 3, this.encodedValue[0], this.encodedValue[1], this.encodedValue[2]};
            }
            case 4: {
                return new byte[]{this.getType(), 4, this.encodedValue[0], this.encodedValue[1], this.encodedValue[2], this.encodedValue[3]};
            }
        }
        throw new AssertionError((Object)("Invalid enumerated value length:  " + this.encodedValue.length));
    }

    public void encodeTo(ByteStringBuffer buffer) {
        buffer.append(this.getType());
        ASN1Enumerated.encodeLengthTo(this.encodedValue.length, buffer);
        buffer.append(this.encodedValue);
    }

    public static ASN1Enumerated decodeAsEnumerated(byte[] elementBytes) throws ASN1Exception {
        try {
            int intValue;
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] value = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, value, 0, length);
            switch (value.length) {
                case 1: {
                    intValue = value[0] & 0xFF;
                    if ((value[0] & 0x80) == 0) break;
                    intValue |= 0xFFFFFF00;
                    break;
                }
                case 2: {
                    intValue = (value[0] & 0xFF) << 8 | value[1] & 0xFF;
                    if ((value[0] & 0x80) == 0) break;
                    intValue |= 0xFFFF0000;
                    break;
                }
                case 3: {
                    intValue = (value[0] & 0xFF) << 16 | (value[1] & 0xFF) << 8 | value[2] & 0xFF;
                    if ((value[0] & 0x80) == 0) break;
                    intValue |= 0xFF000000;
                    break;
                }
                case 4: {
                    intValue = (value[0] & 0xFF) << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
                    break;
                }
                default: {
                    throw new ASN1Exception(ASN1Messages.ERR_ENUMERATED_INVALID_LENGTH.get(value.length));
                }
            }
            return new ASN1Enumerated(elementBytes[0], intValue, value);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw ae;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    public static ASN1Enumerated decodeAsEnumerated(ASN1Element element) throws ASN1Exception {
        int intValue;
        byte[] value = element.getValue();
        switch (value.length) {
            case 1: {
                intValue = value[0] & 0xFF;
                if ((value[0] & 0x80) == 0) break;
                intValue |= 0xFFFFFF00;
                break;
            }
            case 2: {
                intValue = (value[0] & 0xFF) << 8 | value[1] & 0xFF;
                if ((value[0] & 0x80) == 0) break;
                intValue |= 0xFFFF0000;
                break;
            }
            case 3: {
                intValue = (value[0] & 0xFF) << 16 | (value[1] & 0xFF) << 8 | value[2] & 0xFF;
                if ((value[0] & 0x80) == 0) break;
                intValue |= 0xFF000000;
                break;
            }
            case 4: {
                intValue = (value[0] & 0xFF) << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
                break;
            }
            default: {
                throw new ASN1Exception(ASN1Messages.ERR_ENUMERATED_INVALID_LENGTH.get(value.length));
            }
        }
        return new ASN1Enumerated(element.getType(), intValue, value);
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.intValue);
    }
}

