/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.AcceptAllSimpleMatchingRule;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CaseIgnoreStringMatchingRule
extends AcceptAllSimpleMatchingRule {
    private static final CaseIgnoreStringMatchingRule INSTANCE = new CaseIgnoreStringMatchingRule();
    private static final long serialVersionUID = -1293370922676445525L;

    public static CaseIgnoreStringMatchingRule getInstance() {
        return INSTANCE;
    }

    public boolean valuesMatch(ASN1OctetString value1, ASN1OctetString value2) {
        byte[] value2Bytes;
        byte[] value1Bytes = value1.getValue();
        if (value1Bytes.length == (value2Bytes = value2.getValue()).length) {
            for (int i = 0; i < value1Bytes.length; ++i) {
                char c;
                byte b1 = value1Bytes[i];
                byte b2 = value2Bytes[i];
                if ((b1 & 0x7F) != (b1 & 0xFF) || (b2 & 0x7F) != (b2 & 0xFF)) {
                    return this.normalize(value1).equals(this.normalize(value2));
                }
                if (b1 == b2) continue;
                if (b1 == 32 || b2 == 32) {
                    return this.normalize(value1).equals(this.normalize(value2));
                }
                if (Character.isUpperCase((char)b1)) {
                    c = Character.toLowerCase((char)b1);
                    if (c == (char)b2) continue;
                    return false;
                }
                if (Character.isUpperCase((char)b2)) {
                    c = Character.toLowerCase((char)b2);
                    if (c == (char)b1) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return CaseIgnoreStringMatchingRule.normalizeInternal(value1, false, (byte)0).equals(CaseIgnoreStringMatchingRule.normalizeInternal(value2, false, (byte)0));
    }

    public ASN1OctetString normalize(ASN1OctetString value) {
        return CaseIgnoreStringMatchingRule.normalizeInternal(value, false, (byte)0);
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) {
        return CaseIgnoreStringMatchingRule.normalizeInternal(value, true, substringType);
    }

    private static ASN1OctetString normalizeInternal(ASN1OctetString value, boolean isSubstring, byte substringType) {
        boolean trimFinal;
        boolean trimInitial;
        byte[] valueBytes = value.getValue();
        if (valueBytes.length == 0) {
            return value;
        }
        if (isSubstring) {
            switch (substringType) {
                case -128: {
                    trimInitial = true;
                    trimFinal = false;
                    break;
                }
                case -126: {
                    trimInitial = false;
                    trimFinal = true;
                    break;
                }
                default: {
                    trimInitial = false;
                    trimFinal = false;
                    break;
                }
            }
        } else {
            trimInitial = true;
            trimFinal = true;
        }
        boolean containsNonSpace = false;
        boolean lastWasSpace = trimInitial;
        int numDuplicates = 0;
        for (byte b : valueBytes) {
            if ((b & 0x7F) != (b & 0xFF)) {
                return CaseIgnoreStringMatchingRule.normalizeNonASCII(value, trimInitial, trimFinal);
            }
            if (b == 32) {
                if (lastWasSpace) {
                    ++numDuplicates;
                    continue;
                }
                lastWasSpace = true;
                continue;
            }
            containsNonSpace = true;
            lastWasSpace = false;
        }
        if (!containsNonSpace) {
            return new ASN1OctetString(" ");
        }
        if (lastWasSpace && trimFinal) {
            ++numDuplicates;
        }
        lastWasSpace = trimInitial;
        int targetPos = 0;
        byte[] normalizedBytes = new byte[valueBytes.length - numDuplicates];
        block34: for (int i = 0; i < valueBytes.length; ++i) {
            switch (valueBytes[i]) {
                case 32: {
                    if (lastWasSpace || trimFinal && i == valueBytes.length - 1 || targetPos >= normalizedBytes.length) continue block34;
                    normalizedBytes[targetPos++] = 32;
                    lastWasSpace = true;
                    continue block34;
                }
                case 65: {
                    normalizedBytes[targetPos++] = 97;
                    lastWasSpace = false;
                    continue block34;
                }
                case 66: {
                    normalizedBytes[targetPos++] = 98;
                    lastWasSpace = false;
                    continue block34;
                }
                case 67: {
                    normalizedBytes[targetPos++] = 99;
                    lastWasSpace = false;
                    continue block34;
                }
                case 68: {
                    normalizedBytes[targetPos++] = 100;
                    lastWasSpace = false;
                    continue block34;
                }
                case 69: {
                    normalizedBytes[targetPos++] = 101;
                    lastWasSpace = false;
                    continue block34;
                }
                case 70: {
                    normalizedBytes[targetPos++] = 102;
                    lastWasSpace = false;
                    continue block34;
                }
                case 71: {
                    normalizedBytes[targetPos++] = 103;
                    lastWasSpace = false;
                    continue block34;
                }
                case 72: {
                    normalizedBytes[targetPos++] = 104;
                    lastWasSpace = false;
                    continue block34;
                }
                case 73: {
                    normalizedBytes[targetPos++] = 105;
                    lastWasSpace = false;
                    continue block34;
                }
                case 74: {
                    normalizedBytes[targetPos++] = 106;
                    lastWasSpace = false;
                    continue block34;
                }
                case 75: {
                    normalizedBytes[targetPos++] = 107;
                    lastWasSpace = false;
                    continue block34;
                }
                case 76: {
                    normalizedBytes[targetPos++] = 108;
                    lastWasSpace = false;
                    continue block34;
                }
                case 77: {
                    normalizedBytes[targetPos++] = 109;
                    lastWasSpace = false;
                    continue block34;
                }
                case 78: {
                    normalizedBytes[targetPos++] = 110;
                    lastWasSpace = false;
                    continue block34;
                }
                case 79: {
                    normalizedBytes[targetPos++] = 111;
                    lastWasSpace = false;
                    continue block34;
                }
                case 80: {
                    normalizedBytes[targetPos++] = 112;
                    lastWasSpace = false;
                    continue block34;
                }
                case 81: {
                    normalizedBytes[targetPos++] = 113;
                    lastWasSpace = false;
                    continue block34;
                }
                case 82: {
                    normalizedBytes[targetPos++] = 114;
                    lastWasSpace = false;
                    continue block34;
                }
                case 83: {
                    normalizedBytes[targetPos++] = 115;
                    lastWasSpace = false;
                    continue block34;
                }
                case 84: {
                    normalizedBytes[targetPos++] = 116;
                    lastWasSpace = false;
                    continue block34;
                }
                case 85: {
                    normalizedBytes[targetPos++] = 117;
                    lastWasSpace = false;
                    continue block34;
                }
                case 86: {
                    normalizedBytes[targetPos++] = 118;
                    lastWasSpace = false;
                    continue block34;
                }
                case 87: {
                    normalizedBytes[targetPos++] = 119;
                    lastWasSpace = false;
                    continue block34;
                }
                case 88: {
                    normalizedBytes[targetPos++] = 120;
                    lastWasSpace = false;
                    continue block34;
                }
                case 89: {
                    normalizedBytes[targetPos++] = 121;
                    lastWasSpace = false;
                    continue block34;
                }
                case 90: {
                    normalizedBytes[targetPos++] = 122;
                    lastWasSpace = false;
                    continue block34;
                }
                default: {
                    normalizedBytes[targetPos++] = valueBytes[i];
                    lastWasSpace = false;
                }
            }
        }
        return new ASN1OctetString(normalizedBytes);
    }

    private static ASN1OctetString normalizeNonASCII(ASN1OctetString value, boolean trimInitial, boolean trimFinal) {
        StringBuilder buffer = new StringBuilder(value.stringValue());
        int pos = 0;
        boolean lastWasSpace = trimInitial;
        while (pos < buffer.length()) {
            char c;
            if (Character.isSpaceChar(c = buffer.charAt(pos++))) {
                if (lastWasSpace || trimFinal && pos >= buffer.length()) {
                    buffer.deleteCharAt(--pos);
                    continue;
                }
                lastWasSpace = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                buffer.setCharAt(pos - 1, Character.toLowerCase(c));
            }
            lastWasSpace = false;
        }
        if (trimFinal && Character.isSpaceChar(buffer.charAt(buffer.length() - 1))) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return new ASN1OctetString(buffer.toString());
    }
}

