/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DistinguishedNameMatchingRule
extends MatchingRule {
    private static final DistinguishedNameMatchingRule INSTANCE = new DistinguishedNameMatchingRule();
    private static final long serialVersionUID = -2617356571703597868L;

    public static DistinguishedNameMatchingRule getInstance() {
        return INSTANCE;
    }

    public boolean valuesMatch(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        DN dn2;
        DN dn1;
        try {
            dn1 = new DN(value1.stringValue());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
        try {
            dn2 = new DN(value2.stringValue());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
        return dn1.equals(dn2);
    }

    public boolean matchesSubstring(ASN1OctetString value, ASN1OctetString subInitial, ASN1OctetString[] subAny, ASN1OctetString subFinal) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    public int compareValues(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    public ASN1OctetString normalize(ASN1OctetString value) throws LDAPException {
        try {
            DN dn = new DN(value.stringValue());
            return new ASN1OctetString(dn.toNormalizedString());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

