/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NumericStringMatchingRule
extends SimpleMatchingRule {
    private static final NumericStringMatchingRule INSTANCE = new NumericStringMatchingRule();
    private static final long serialVersionUID = -898484312052746321L;

    public static NumericStringMatchingRule getInstance() {
        return INSTANCE;
    }

    public ASN1OctetString normalize(ASN1OctetString value) throws LDAPException {
        int numSpaces = 0;
        byte[] valueBytes = value.getValue();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 32) {
                ++numSpaces;
                continue;
            }
            if (valueBytes[i] >= 48 && valueBytes[i] <= 57) continue;
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_NUMERIC_STRING_INVALID_CHARACTER.get(i));
        }
        if (numSpaces == 0) {
            return value;
        }
        int pos = 0;
        byte[] returnBytes = new byte[valueBytes.length - numSpaces];
        for (byte b : valueBytes) {
            if (b == 32) continue;
            returnBytes[pos++] = b;
        }
        return new ASN1OctetString(returnBytes);
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) throws LDAPException {
        return this.normalize(value);
    }
}

