/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPMessage
implements Serializable {
    public static final byte PROTOCOL_OP_TYPE_BIND_REQUEST = 96;
    public static final byte PROTOCOL_OP_TYPE_BIND_RESPONSE = 97;
    public static final byte PROTOCOL_OP_TYPE_UNBIND_REQUEST = 66;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_REQUEST = 99;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_RESULT_ENTRY = 100;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_RESULT_REFERENCE = 115;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_RESULT_DONE = 101;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_REQUEST = 102;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_RESPONSE = 103;
    public static final byte PROTOCOL_OP_TYPE_ADD_REQUEST = 104;
    public static final byte PROTOCOL_OP_TYPE_ADD_RESPONSE = 105;
    public static final byte PROTOCOL_OP_TYPE_DELETE_REQUEST = 74;
    public static final byte PROTOCOL_OP_TYPE_DELETE_RESPONSE = 107;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_DN_REQUEST = 108;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_DN_RESPONSE = 109;
    public static final byte PROTOCOL_OP_TYPE_COMPARE_REQUEST = 110;
    public static final byte PROTOCOL_OP_TYPE_COMPARE_RESPONSE = 111;
    public static final byte PROTOCOL_OP_TYPE_ABANDON_REQUEST = 80;
    public static final byte PROTOCOL_OP_TYPE_EXTENDED_REQUEST = 119;
    public static final byte PROTOCOL_OP_TYPE_EXTENDED_RESPONSE = 120;
    public static final byte PROTOCOL_OP_TYPE_INTERMEDIATE_RESPONSE = 121;
    public static final byte MESSAGE_TYPE_CONTROLS = -96;
    private static final long serialVersionUID = 909272448857832592L;
    private final int messageID;
    private final ProtocolOp protocolOp;
    private final List<Control> controls;

    public LDAPMessage(int messageID, ProtocolOp protocolOp, Control ... controls) {
        this.messageID = messageID;
        this.protocolOp = protocolOp;
        this.controls = controls == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(controls));
    }

    public LDAPMessage(int messageID, ProtocolOp protocolOp, List<Control> controls) {
        this.messageID = messageID;
        this.protocolOp = protocolOp;
        this.controls = controls == null ? Collections.emptyList() : Collections.unmodifiableList(controls);
    }

    public int getMessageID() {
        return this.messageID;
    }

    public ProtocolOp getProtocolOp() {
        return this.protocolOp;
    }

    public byte getProtocolOpType() {
        return this.protocolOp.getProtocolOpType();
    }

    public AbandonRequestProtocolOp getAbandonRequestProtocolOp() throws ClassCastException {
        return (AbandonRequestProtocolOp)this.protocolOp;
    }

    public AddRequestProtocolOp getAddRequestProtocolOp() throws ClassCastException {
        return (AddRequestProtocolOp)this.protocolOp;
    }

    public AddResponseProtocolOp getAddResponseProtocolOp() throws ClassCastException {
        return (AddResponseProtocolOp)this.protocolOp;
    }

    public BindRequestProtocolOp getBindRequestProtocolOp() throws ClassCastException {
        return (BindRequestProtocolOp)this.protocolOp;
    }

    public BindResponseProtocolOp getBindResponseProtocolOp() throws ClassCastException {
        return (BindResponseProtocolOp)this.protocolOp;
    }

    public CompareRequestProtocolOp getCompareRequestProtocolOp() throws ClassCastException {
        return (CompareRequestProtocolOp)this.protocolOp;
    }

    public CompareResponseProtocolOp getCompareResponseProtocolOp() throws ClassCastException {
        return (CompareResponseProtocolOp)this.protocolOp;
    }

    public DeleteRequestProtocolOp getDeleteRequestProtocolOp() throws ClassCastException {
        return (DeleteRequestProtocolOp)this.protocolOp;
    }

    public DeleteResponseProtocolOp getDeleteResponseProtocolOp() throws ClassCastException {
        return (DeleteResponseProtocolOp)this.protocolOp;
    }

    public ExtendedRequestProtocolOp getExtendedRequestProtocolOp() throws ClassCastException {
        return (ExtendedRequestProtocolOp)this.protocolOp;
    }

    public ExtendedResponseProtocolOp getExtendedResponseProtocolOp() throws ClassCastException {
        return (ExtendedResponseProtocolOp)this.protocolOp;
    }

    public ModifyRequestProtocolOp getModifyRequestProtocolOp() throws ClassCastException {
        return (ModifyRequestProtocolOp)this.protocolOp;
    }

    public ModifyResponseProtocolOp getModifyResponseProtocolOp() throws ClassCastException {
        return (ModifyResponseProtocolOp)this.protocolOp;
    }

    public ModifyDNRequestProtocolOp getModifyDNRequestProtocolOp() throws ClassCastException {
        return (ModifyDNRequestProtocolOp)this.protocolOp;
    }

    public ModifyDNResponseProtocolOp getModifyDNResponseProtocolOp() throws ClassCastException {
        return (ModifyDNResponseProtocolOp)this.protocolOp;
    }

    public SearchRequestProtocolOp getSearchRequestProtocolOp() throws ClassCastException {
        return (SearchRequestProtocolOp)this.protocolOp;
    }

    public SearchResultEntryProtocolOp getSearchResultEntryProtocolOp() throws ClassCastException {
        return (SearchResultEntryProtocolOp)this.protocolOp;
    }

    public SearchResultReferenceProtocolOp getSearchResultReferenceProtocolOp() throws ClassCastException {
        return (SearchResultReferenceProtocolOp)this.protocolOp;
    }

    public SearchResultDoneProtocolOp getSearchResultDoneProtocolOp() throws ClassCastException {
        return (SearchResultDoneProtocolOp)this.protocolOp;
    }

    public UnbindRequestProtocolOp getUnbindRequestProtocolOp() throws ClassCastException {
        return (UnbindRequestProtocolOp)this.protocolOp;
    }

    public IntermediateResponseProtocolOp getIntermediateResponseProtocolOp() throws ClassCastException {
        return (IntermediateResponseProtocolOp)this.protocolOp;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence messageSequence = buffer.beginSequence();
        buffer.addInteger(this.messageID);
        this.protocolOp.writeTo(buffer);
        if (!this.controls.isEmpty()) {
            ASN1BufferSequence controlsSequence = buffer.beginSequence((byte)-96);
            for (Control c : this.controls) {
                c.writeTo(buffer);
            }
            controlsSequence.end();
        }
        messageSequence.end();
    }

    public static LDAPMessage readFrom(ASN1StreamReader reader, boolean ignoreSocketTimeout) throws LDAPException {
        ASN1StreamReaderSequence messageSequence;
        try {
            reader.setIgnoreSocketTimeout(false);
            messageSequence = reader.beginSequence();
            if (messageSequence == null) {
                return null;
            }
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ProtocolOp protocolOp;
            reader.setIgnoreSocketTimeout(ignoreSocketTimeout);
            int messageID = reader.readInteger();
            byte protocolOpType = (byte)reader.peek();
            switch (protocolOpType) {
                case 96: {
                    protocolOp = new BindRequestProtocolOp(reader);
                    break;
                }
                case 97: {
                    protocolOp = new BindResponseProtocolOp(reader);
                    break;
                }
                case 66: {
                    protocolOp = new UnbindRequestProtocolOp(reader);
                    break;
                }
                case 99: {
                    protocolOp = new SearchRequestProtocolOp(reader);
                    break;
                }
                case 100: {
                    protocolOp = new SearchResultEntryProtocolOp(reader);
                    break;
                }
                case 115: {
                    protocolOp = new SearchResultReferenceProtocolOp(reader);
                    break;
                }
                case 101: {
                    protocolOp = new SearchResultDoneProtocolOp(reader);
                    break;
                }
                case 102: {
                    protocolOp = new ModifyRequestProtocolOp(reader);
                    break;
                }
                case 103: {
                    protocolOp = new ModifyResponseProtocolOp(reader);
                    break;
                }
                case 104: {
                    protocolOp = new AddRequestProtocolOp(reader);
                    break;
                }
                case 105: {
                    protocolOp = new AddResponseProtocolOp(reader);
                    break;
                }
                case 74: {
                    protocolOp = new DeleteRequestProtocolOp(reader);
                    break;
                }
                case 107: {
                    protocolOp = new DeleteResponseProtocolOp(reader);
                    break;
                }
                case 108: {
                    protocolOp = new ModifyDNRequestProtocolOp(reader);
                    break;
                }
                case 109: {
                    protocolOp = new ModifyDNResponseProtocolOp(reader);
                    break;
                }
                case 110: {
                    protocolOp = new CompareRequestProtocolOp(reader);
                    break;
                }
                case 111: {
                    protocolOp = new CompareResponseProtocolOp(reader);
                    break;
                }
                case 80: {
                    protocolOp = new AbandonRequestProtocolOp(reader);
                    break;
                }
                case 119: {
                    protocolOp = new ExtendedRequestProtocolOp(reader);
                    break;
                }
                case 120: {
                    protocolOp = new ExtendedResponseProtocolOp(reader);
                    break;
                }
                case 121: {
                    protocolOp = new IntermediateResponseProtocolOp(reader);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_INVALID_PROTOCOL_OP_TYPE.get(StaticUtils.toHex(protocolOpType)));
                }
            }
            LinkedList<Control> controls = new LinkedList<Control>();
            if (messageSequence.hasMoreElements()) {
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controls.add(Control.readFrom(reader));
                }
            }
            return new LDAPMessage(messageID, protocolOp, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (SocketTimeoutException ste) {
            Debug.debugException(ste);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(ste)));
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public static LDAPResponse readLDAPResponseFrom(ASN1StreamReader reader, boolean ignoreSocketTimeout) throws LDAPException {
        return LDAPMessage.readLDAPResponseFrom(reader, ignoreSocketTimeout, null);
    }

    public static LDAPResponse readLDAPResponseFrom(ASN1StreamReader reader, boolean ignoreSocketTimeout, Schema schema) throws LDAPException {
        ASN1StreamReaderSequence messageSequence;
        try {
            reader.setIgnoreSocketTimeout(false);
            messageSequence = reader.beginSequence();
            if (messageSequence == null) {
                return null;
            }
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            reader.setIgnoreSocketTimeout(ignoreSocketTimeout);
            int messageID = reader.readInteger();
            byte protocolOpType = (byte)reader.peek();
            switch (protocolOpType) {
                case 103: 
                case 105: 
                case 107: 
                case 109: {
                    return InternalSDKHelper.readLDAPResultFrom(messageID, messageSequence, reader);
                }
                case 97: {
                    return InternalSDKHelper.readBindResultFrom(messageID, messageSequence, reader);
                }
                case 111: {
                    return InternalSDKHelper.readCompareResultFrom(messageID, messageSequence, reader);
                }
                case 120: {
                    return InternalSDKHelper.readExtendedResultFrom(messageID, messageSequence, reader);
                }
                case 100: {
                    return InternalSDKHelper.readSearchResultEntryFrom(messageID, messageSequence, reader, schema);
                }
                case 115: {
                    return InternalSDKHelper.readSearchResultReferenceFrom(messageID, messageSequence, reader);
                }
                case 101: {
                    return InternalSDKHelper.readSearchResultFrom(messageID, messageSequence, reader);
                }
                case 121: {
                    return InternalSDKHelper.readIntermediateResponseFrom(messageID, messageSequence, reader);
                }
                case 66: 
                case 74: 
                case 80: 
                case 96: 
                case 99: 
                case 102: 
                case 104: 
                case 108: 
                case 110: 
                case 119: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_PROTOCOL_OP_TYPE_NOT_RESPONSE.get(StaticUtils.toHex(protocolOpType)));
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_INVALID_PROTOCOL_OP_TYPE.get(StaticUtils.toHex(protocolOpType)));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (SocketTimeoutException ste) {
            Debug.debugException(ste);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(ste)));
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPMessage(msgID=");
        buffer.append(this.messageID);
        buffer.append(", protocolOp=");
        this.protocolOp.toString(buffer);
        if (!this.controls.isEmpty()) {
            buffer.append(", controls={");
            Iterator<Control> iterator = this.controls.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

