/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ANONYMOUSBindRequest
extends SASLBindRequest {
    public static final String ANONYMOUS_MECHANISM_NAME = "ANONYMOUS";
    private static final long serialVersionUID = 4259102841471750866L;
    private final String traceString;

    public ANONYMOUSBindRequest() {
        this((String)null, NO_CONTROLS);
    }

    public ANONYMOUSBindRequest(String traceString) {
        this(traceString, NO_CONTROLS);
    }

    public ANONYMOUSBindRequest(Control ... controls) {
        this((String)null, controls);
    }

    public ANONYMOUSBindRequest(String traceString, Control ... controls) {
        super(controls);
        this.traceString = traceString;
    }

    public String getSASLMechanismName() {
        return ANONYMOUS_MECHANISM_NAME;
    }

    public String getTraceString() {
        return this.traceString;
    }

    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        ASN1OctetString credentials = null;
        if (this.traceString == null || this.traceString.length() == 0) {
            credentials = new ASN1OctetString(this.traceString);
        }
        return this.sendBindRequest(connection, null, credentials, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    public ANONYMOUSBindRequest getRebindRequest(String host, int port) {
        return new ANONYMOUSBindRequest(this.traceString, this.getControls());
    }

    public ANONYMOUSBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public ANONYMOUSBindRequest duplicate(Control[] controls) {
        return new ANONYMOUSBindRequest(this.traceString, controls);
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("ANONYMOUSBindRequest(");
        if (this.traceString != null) {
            buffer.append(", trace='");
            buffer.append(this.traceString);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

