/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EXTERNALBindRequest
extends SASLBindRequest {
    public static final String EXTERNAL_MECHANISM_NAME = "EXTERNAL";
    private static final long serialVersionUID = 7520760039662616663L;
    private int messageID = -1;

    public EXTERNALBindRequest() {
        super(null);
    }

    public EXTERNALBindRequest(Control ... controls) {
        super(controls);
    }

    public String getSASLMechanismName() {
        return EXTERNAL_MECHANISM_NAME;
    }

    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        this.messageID = connection.nextMessageID();
        return this.sendBindRequest(connection, "", null, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    public EXTERNALBindRequest getRebindRequest(String host, int port) {
        return new EXTERNALBindRequest(this.getControls());
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public EXTERNALBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public EXTERNALBindRequest duplicate(Control[] controls) {
        return new EXTERNALBindRequest(controls);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EXTERNALBindRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

