/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public abstract class UpdatableLDAPRequest
extends LDAPRequest {
    private static final long serialVersionUID = 2487230102594573848L;

    protected UpdatableLDAPRequest(Control[] controls) {
        super(controls);
    }

    public final void setControls(Control ... controls) {
        if (controls == null) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            this.setControlsInternal(controls);
        }
    }

    public final void setControls(List<Control> controls) {
        if (controls == null || controls.isEmpty()) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            Control[] controlArray = new Control[controls.size()];
            this.setControlsInternal(controls.toArray(controlArray));
        }
    }

    public final void clearControls() {
        this.setControlsInternal(NO_CONTROLS);
    }

    public final void addControl(Control control) {
        Validator.ensureNotNull(control);
        Control[] controls = this.getControls();
        Control[] newControls = new Control[controls.length + 1];
        System.arraycopy(controls, 0, newControls, 0, controls.length);
        newControls[controls.length] = control;
        this.setControlsInternal(newControls);
    }

    public final void addControls(Control ... controls) {
        if (controls == null || controls.length == 0) {
            return;
        }
        Control[] currentControls = this.getControls();
        Control[] newControls = new Control[currentControls.length + controls.length];
        System.arraycopy(currentControls, 0, newControls, 0, currentControls.length);
        System.arraycopy(controls, 0, newControls, currentControls.length, controls.length);
        this.setControlsInternal(newControls);
    }

    public final Control removeControl(String oid) {
        Validator.ensureNotNull(oid);
        Control[] controls = this.getControls();
        int pos = -1;
        Control c = null;
        for (int i = 0; i < controls.length; ++i) {
            if (!controls[i].getOID().equals(oid)) continue;
            c = controls[i];
            pos = i;
            break;
        }
        if (pos < 0) {
            return null;
        }
        if (controls.length == 1) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            Control[] newControls = new Control[controls.length - 1];
            int j = 0;
            for (int i = 0; i < controls.length; ++i) {
                if (i == pos) continue;
                newControls[j++] = controls[i];
            }
            this.setControlsInternal(newControls);
        }
        return c;
    }

    public final boolean removeControl(Control control) {
        Validator.ensureNotNull(control);
        Control[] controls = this.getControls();
        int pos = -1;
        for (int i = 0; i < controls.length; ++i) {
            if (!controls[i].equals(control)) continue;
            pos = i;
            break;
        }
        if (pos < 0) {
            return false;
        }
        if (controls.length == 1) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            Control[] newControls = new Control[controls.length - 1];
            int j = 0;
            for (int i = 0; i < controls.length; ++i) {
                if (i == pos) continue;
                newControls[j++] = controls[i];
            }
            this.setControlsInternal(newControls);
        }
        return true;
    }

    public final Control replaceControl(Control control) {
        Validator.ensureNotNull(control);
        return this.replaceControl(control.getOID(), control);
    }

    public final Control replaceControl(String oid, Control control) {
        Validator.ensureNotNull(oid);
        if (control == null) {
            return this.removeControl(oid);
        }
        Control[] controls = this.getControls();
        for (int i = 0; i < controls.length; ++i) {
            if (!controls[i].getOID().equals(oid)) continue;
            Control c = controls[i];
            controls[i] = control;
            this.setControlsInternal(controls);
            return c;
        }
        Control[] newControls = new Control[controls.length + 1];
        System.arraycopy(controls, 0, newControls, 0, controls.length);
        newControls[controls.length] = control;
        this.setControlsInternal(newControls);
        return null;
    }

    public final void setResponseTimeoutMillis(long responseTimeout) {
        if (responseTimeout < 0L) {
            this.setResponseTimeoutMillisInternal(-1L);
        } else {
            this.setResponseTimeoutMillisInternal(responseTimeout);
        }
    }
}

