/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ValuePattern;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ModRateThread
extends Thread {
    private final AtomicBoolean startRequested;
    private final AtomicBoolean stopRequested;
    private final AtomicLong errorCounter;
    private final AtomicLong modCounter;
    private final AtomicLong modDurations;
    private final byte[] charSet;
    private final int valueLength;
    private final LDAPConnection connection;
    private final Random random;
    private final AtomicReference<ResultCode> resultCode;
    private final String[] attributes;
    private final AtomicReference<Thread> modThread;
    private final ValuePattern entryDN;
    private final FixedRateBarrier fixedRateBarrier;

    ModRateThread(int threadNumber, LDAPConnection connection, ValuePattern entryDN, String[] attributes, byte[] charSet, int valueLength, long randomSeed, AtomicBoolean shouldStart, AtomicLong modCounter, AtomicLong modDurations, AtomicLong errorCounter, FixedRateBarrier rateBarrier) {
        this.setName("ModRate Thread " + threadNumber);
        this.setDaemon(true);
        this.connection = connection;
        this.entryDN = entryDN;
        this.attributes = attributes;
        this.charSet = charSet;
        this.valueLength = valueLength;
        this.modCounter = modCounter;
        this.modDurations = modDurations;
        this.errorCounter = errorCounter;
        this.startRequested = shouldStart;
        this.fixedRateBarrier = rateBarrier;
        connection.setConnectionName("mod-" + threadNumber);
        this.resultCode = new AtomicReference<Object>(null);
        this.modThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.random = new Random(randomSeed);
    }

    public void run() {
        this.modThread.set(ModRateThread.currentThread());
        Modification[] mods = new Modification[this.attributes.length];
        byte[] valueBytes = new byte[this.valueLength];
        ASN1OctetString[] values = new ASN1OctetString[1];
        while (!this.startRequested.get()) {
            ModRateThread.yield();
        }
        while (!this.stopRequested.get()) {
            int i;
            for (i = 0; i < this.valueLength; ++i) {
                valueBytes[i] = this.charSet[this.random.nextInt(this.charSet.length)];
            }
            values[0] = new ASN1OctetString(valueBytes);
            for (i = 0; i < this.attributes.length; ++i) {
                mods[i] = new Modification(ModificationType.REPLACE, this.attributes[i], values);
            }
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.await();
            }
            long startTime = System.nanoTime();
            try {
                this.connection.modify(this.entryDN.nextValue(), mods);
            }
            catch (LDAPException le) {
                this.errorCounter.incrementAndGet();
                this.resultCode.compareAndSet(null, le.getResultCode());
            }
            this.modCounter.incrementAndGet();
            this.modDurations.addAndGet(System.nanoTime() - startTime);
        }
        this.connection.close();
        this.modThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.modThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

