/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ValuePattern;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class SearchRateThread
extends Thread
implements SearchResultListener {
    private static final long serialVersionUID = -6714705986829223364L;
    private final AtomicBoolean startRequested;
    private final AtomicBoolean stopRequested;
    private final AtomicLong entryCounter;
    private final AtomicLong errorCounter;
    private final AtomicLong searchCounter;
    private final AtomicLong searchDurations;
    private final LDAPConnection connection;
    private final AtomicReference<ResultCode> resultCode;
    private final SearchRequest searchRequest;
    private final AtomicReference<Thread> searchThread;
    private final ValuePattern baseDN;
    private final ValuePattern filter;
    private final FixedRateBarrier fixedRateBarrier;

    SearchRateThread(int threadNumber, LDAPConnection connection, ValuePattern baseDN, SearchScope scope, ValuePattern filter, String[] attributes, AtomicBoolean shouldStart, AtomicLong searchCounter, AtomicLong entryCounter, AtomicLong searchDurations, AtomicLong errorCounter, FixedRateBarrier rateBarrier) {
        this.setName("SearchRate Thread " + threadNumber);
        this.setDaemon(true);
        this.connection = connection;
        this.baseDN = baseDN;
        this.filter = filter;
        this.searchCounter = searchCounter;
        this.entryCounter = entryCounter;
        this.searchDurations = searchDurations;
        this.errorCounter = errorCounter;
        this.startRequested = shouldStart;
        this.fixedRateBarrier = rateBarrier;
        connection.setConnectionName("search-" + threadNumber);
        this.resultCode = new AtomicReference<Object>(null);
        this.searchThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.searchRequest = new SearchRequest((SearchResultListener)this, "", scope, Filter.createPresenceFilter("objectClass"), attributes);
    }

    public void run() {
        this.searchThread.set(SearchRateThread.currentThread());
        while (!this.startRequested.get()) {
            SearchRateThread.yield();
        }
        while (!this.stopRequested.get()) {
            try {
                this.searchRequest.setBaseDN(this.baseDN.nextValue());
                this.searchRequest.setFilter(this.filter.nextValue());
            }
            catch (LDAPException le) {
                this.errorCounter.incrementAndGet();
                this.resultCode.compareAndSet(null, le.getResultCode());
                continue;
            }
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.await();
            }
            long startTime = System.nanoTime();
            try {
                SearchResult r = this.connection.search(this.searchRequest);
                this.entryCounter.addAndGet(r.getEntryCount());
            }
            catch (LDAPSearchException lse) {
                this.errorCounter.incrementAndGet();
                this.entryCounter.addAndGet(lse.getEntryCount());
                this.resultCode.compareAndSet(null, lse.getResultCode());
            }
            this.searchCounter.incrementAndGet();
            this.searchDurations.addAndGet(System.nanoTime() - startTime);
        }
        this.connection.close();
        this.searchThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.searchThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }

    public void searchEntryReturned(SearchResultEntry searchEntry) {
    }

    public void searchReferenceReturned(SearchResultReference searchReference) {
    }
}

