/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ExtOpMessages {
    ERR_CANCEL_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE("Cancel operations are not supported on connections operating in synchronous mode"),
    ERR_CANCEL_REQUEST_CANNOT_DECODE("The provided extended request cannot be decoded as a cancel request because an error occurred while attempting to parse the value:  {0}"),
    ERR_CANCEL_REQUEST_NO_VALUE("The provided extended request cannot be decoded as a cancel request because it does not have a value."),
    ERR_PW_MODIFY_REQUEST_CANNOT_DECODE("The provided extended request cannot be decoded as a password modify request because an error occurred while attempting to parse the value:  {0}"),
    ERR_PW_MODIFY_REQUEST_INVALID_TYPE("The provided extended request cannot be decoded as a password modify request because an element in the value sequence had an invalid BER type of {0}."),
    ERR_PW_MODIFY_REQUEST_NO_VALUE("The provided extended request cannot be decoded as a password modify request because it does not have a value."),
    ERR_PW_MODIFY_RESPONSE_MULTIPLE_ELEMENTS("Unable to decode the provided extended result as a password modify extended result because the value sequence contained multiple elements."),
    ERR_PW_MODIFY_RESPONSE_VALUE_NOT_SEQUENCE("Unable to decode the provided extended result as a password modify extended result because the value element could not be decoded as an ASN.1 sequence:  {0}"),
    ERR_STARTTLS_REQUEST_CANNOT_COMPLETE("Unable to complete StartTLS negotiation over the existing socket:  {0}"),
    ERR_STARTTLS_REQUEST_CANNOT_CREATE_DEFAULT_CONTEXT("An error occurred while attempting to create a default SSL context:  {0}"),
    ERR_STARTTLS_REQUEST_CANNOT_PROCESS("Unable to process the StartTLS operation:  {0}  The connection has been closed."),
    ERR_STARTTLS_REQUEST_HAS_VALUE("The provided extended cannot request be decoded as a StartTLS request because it has a value."),
    ERR_WHO_AM_I_REQUEST_HAS_VALUE("The provided extended request cannot be decoded as a Who Am I? request because it has a value."),
    INFO_EXTENDED_REQUEST_NAME_CANCEL("Cancel Extended Request"),
    INFO_EXTENDED_REQUEST_NAME_PASSWORD_MODIFY("Password Modify Extended Request"),
    INFO_EXTENDED_REQUEST_NAME_START_TLS("StartTLS Extended Request"),
    INFO_EXTENDED_REQUEST_NAME_WHO_AM_I("Who Am I? Extended Request"),
    INFO_EXTENDED_RESULT_NAME_NOTICE_OF_DISCONNECT("Notice Of Disconnection Extended Result"),
    INFO_EXTENDED_RESULT_NAME_PASSWORD_MODIFY("Password Modify Extended Result"),
    INFO_EXTENDED_RESULT_NAME_WHO_AM_I("Who Am I? Extended Result");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<ExtOpMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<ExtOpMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private ExtOpMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            s = RESOURCE_BUNDLE.getString(this.name());
            MESSAGE_STRINGS.putIfAbsent(this, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            f = RESOURCE_BUNDLE == null ? new MessageFormat(this.defaultText) : new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            return f.format(args);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("extop");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

