/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PasswordModifyExtendedRequest
extends ExtendedRequest {
    public static final String PASSWORD_MODIFY_REQUEST_OID = "1.3.6.1.4.1.4203.1.11.1";
    private static final byte TYPE_USER_IDENTITY = -128;
    private static final byte TYPE_OLD_PASSWORD = -127;
    private static final byte TYPE_NEW_PASSWORD = -126;
    private static final long serialVersionUID = 4965048727456933570L;
    private final ASN1OctetString oldPassword;
    private final ASN1OctetString newPassword;
    private final String userIdentity;

    public PasswordModifyExtendedRequest(String newPassword) {
        this(null, null, newPassword, null);
    }

    public PasswordModifyExtendedRequest(byte[] newPassword) {
        this(null, null, newPassword, null);
    }

    public PasswordModifyExtendedRequest(String oldPassword, String newPassword) {
        this(null, oldPassword, newPassword, null);
    }

    public PasswordModifyExtendedRequest(byte[] oldPassword, byte[] newPassword) {
        this(null, oldPassword, newPassword, null);
    }

    public PasswordModifyExtendedRequest(String userIdentity, String oldPassword, String newPassword) {
        this(userIdentity, oldPassword, newPassword, null);
    }

    public PasswordModifyExtendedRequest(String userIdentity, byte[] oldPassword, byte[] newPassword) {
        this(userIdentity, oldPassword, newPassword, null);
    }

    public PasswordModifyExtendedRequest(String userIdentity, String oldPassword, String newPassword, Control[] controls) {
        super(PASSWORD_MODIFY_REQUEST_OID, PasswordModifyExtendedRequest.encodeValue(userIdentity, oldPassword, newPassword), controls);
        this.userIdentity = userIdentity;
        this.oldPassword = oldPassword == null ? null : new ASN1OctetString(-127, oldPassword);
        this.newPassword = newPassword == null ? null : new ASN1OctetString(-126, newPassword);
    }

    public PasswordModifyExtendedRequest(String userIdentity, byte[] oldPassword, byte[] newPassword, Control[] controls) {
        super(PASSWORD_MODIFY_REQUEST_OID, PasswordModifyExtendedRequest.encodeValue(userIdentity, oldPassword, newPassword), controls);
        this.userIdentity = userIdentity;
        this.oldPassword = oldPassword == null ? null : new ASN1OctetString(-127, oldPassword);
        this.newPassword = newPassword == null ? null : new ASN1OctetString(-126, newPassword);
    }

    public PasswordModifyExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_MODIFY_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements;
            ASN1OctetString oldPW = null;
            ASN1OctetString newPW = null;
            String userID = null;
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            block8: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(valueElement).elements()) {
                switch (e.getType()) {
                    case -128: {
                        userID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block8;
                    }
                    case -127: {
                        oldPW = ASN1OctetString.decodeAsOctetString(e);
                        continue block8;
                    }
                    case -126: {
                        newPW = ASN1OctetString.decodeAsOctetString(e);
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_MODIFY_REQUEST_INVALID_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.userIdentity = userID;
            this.oldPassword = oldPW;
            this.newPassword = newPW;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_MODIFY_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    private static ASN1OctetString encodeValue(String userIdentity, String oldPassword, String newPassword) {
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(3);
        if (userIdentity != null) {
            elements.add(new ASN1OctetString(-128, userIdentity));
        }
        if (oldPassword != null) {
            elements.add(new ASN1OctetString(-127, oldPassword));
        }
        if (newPassword != null) {
            elements.add(new ASN1OctetString(-126, newPassword));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    private static ASN1OctetString encodeValue(String userIdentity, byte[] oldPassword, byte[] newPassword) {
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(3);
        if (userIdentity != null) {
            elements.add(new ASN1OctetString(-128, userIdentity));
        }
        if (oldPassword != null) {
            elements.add(new ASN1OctetString(-127, oldPassword));
        }
        if (newPassword != null) {
            elements.add(new ASN1OctetString(-126, newPassword));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public String getOldPassword() {
        if (this.oldPassword == null) {
            return null;
        }
        return this.oldPassword.stringValue();
    }

    public byte[] getOldPasswordBytes() {
        if (this.oldPassword == null) {
            return null;
        }
        return this.oldPassword.getValue();
    }

    public ASN1OctetString getRawOldPassword() {
        return this.oldPassword;
    }

    public String getNewPassword() {
        if (this.newPassword == null) {
            return null;
        }
        return this.newPassword.stringValue();
    }

    public byte[] getNewPasswordBytes() {
        if (this.newPassword == null) {
            return null;
        }
        return this.newPassword.getValue();
    }

    public ASN1OctetString getRawNewPassword() {
        return this.newPassword;
    }

    public PasswordModifyExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new PasswordModifyExtendedResult(extendedResponse);
    }

    public PasswordModifyExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public PasswordModifyExtendedRequest duplicate(Control[] controls) {
        byte[] oldPWBytes = this.oldPassword == null ? null : this.oldPassword.getValue();
        byte[] newPWBytes = this.newPassword == null ? null : this.newPassword.getValue();
        return new PasswordModifyExtendedRequest(this.userIdentity, oldPWBytes, newPWBytes, controls);
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_PASSWORD_MODIFY.get();
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("PasswordModifyExtendedRequest(");
        boolean dataAdded = false;
        if (this.userIdentity != null) {
            buffer.append("userIdentity='");
            buffer.append(this.userIdentity);
            buffer.append('\'');
            dataAdded = true;
        }
        if (this.oldPassword != null) {
            if (dataAdded) {
                buffer.append(", ");
            }
            buffer.append("oldPassword='");
            buffer.append(this.oldPassword.stringValue());
            buffer.append('\'');
            dataAdded = true;
        }
        if (this.newPassword != null) {
            if (dataAdded) {
                buffer.append(", ");
            }
            buffer.append("newPassword='");
            buffer.append(this.newPassword.stringValue());
            buffer.append('\'');
            dataAdded = true;
        }
        if ((controls = this.getControls()).length > 0) {
            if (dataAdded) {
                buffer.append(", ");
            }
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

