/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedResult;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class WhoAmIExtendedRequest
extends ExtendedRequest {
    public static final String WHO_AM_I_REQUEST_OID = "1.3.6.1.4.1.4203.1.11.3";
    private static final long serialVersionUID = -2936513698220673318L;

    public WhoAmIExtendedRequest() {
        super(WHO_AM_I_REQUEST_OID);
    }

    public WhoAmIExtendedRequest(Control[] controls) {
        super(WHO_AM_I_REQUEST_OID, controls);
    }

    public WhoAmIExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        if (extendedRequest.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_WHO_AM_I_REQUEST_HAS_VALUE.get());
        }
    }

    public WhoAmIExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new WhoAmIExtendedResult(extendedResponse);
    }

    public WhoAmIExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public WhoAmIExtendedRequest duplicate(Control[] controls) {
        return new WhoAmIExtendedRequest(controls);
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_WHO_AM_I.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("WhoAmIExtendedRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

