/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DITContentRuleDefinition
extends SchemaElement {
    private static final String[] NO_STRINGS = new String[0];
    private static final long serialVersionUID = 3224440505307817586L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String ditContentRuleString;
    private final String oid;
    private final String[] auxiliaryClasses;
    private final String[] names;
    private final String[] optionalAttributes;
    private final String[] prohibitedAttributes;
    private final String[] requiredAttributes;

    public DITContentRuleDefinition(String ditContentRuleString) throws LDAPException {
        String descr;
        Boolean obsolete;
        LinkedHashMap<String, String[]> exts;
        ArrayList<String> auxOCs;
        ArrayList<String> notAttrs;
        ArrayList<String> optAttrs;
        ArrayList<String> reqAttrs;
        ArrayList<String> nameList;
        block21: {
            String token;
            Validator.ensureNotNull(ditContentRuleString);
            this.ditContentRuleString = ditContentRuleString;
            int length = ditContentRuleString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_EMPTY.get());
            }
            if (ditContentRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_NO_OPENING_PAREN.get(ditContentRuleString));
            }
            int pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = DITContentRuleDefinition.readOID(ditContentRuleString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            reqAttrs = new ArrayList<String>();
            optAttrs = new ArrayList<String>();
            notAttrs = new ArrayList<String>();
            auxOCs = new ArrayList<String>();
            exts = new LinkedHashMap<String, String[]>();
            obsolete = null;
            descr = null;
            while (true) {
                int tokenStartPos = pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                while (pos < length && ditContentRuleString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = ditContentRuleString.substring(tokenStartPos, pos);
                String lowerToken = StaticUtils.toLowerCase(token);
                if (lowerToken.equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_CLOSE_NOT_AT_END.get(ditContentRuleString));
                    }
                    break block21;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readQDStrings(ditContentRuleString, pos, length, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = DITContentRuleDefinition.readQDString(ditContentRuleString, pos, length, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "OBSOLETE"));
                }
                if (lowerToken.equals("aux")) {
                    if (auxOCs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(ditContentRuleString, pos, length, auxOCs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "AUX"));
                }
                if (lowerToken.equals("must")) {
                    if (reqAttrs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(ditContentRuleString, pos, length, reqAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "MUST"));
                }
                if (lowerToken.equals("may")) {
                    if (optAttrs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(ditContentRuleString, pos, length, optAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "MAY"));
                }
                if (lowerToken.equals("not")) {
                    if (notAttrs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(ditContentRuleString, pos, length, notAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(ditContentRuleString, "NOT"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = DITContentRuleDefinition.skipSpaces(ditContentRuleString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>();
                pos = DITContentRuleDefinition.readQDStrings(ditContentRuleString, pos, length, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_DUP_EXT.get(ditContentRuleString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_DUP_EXT.get(ditContentRuleString, token));
        }
        this.description = descr;
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.auxiliaryClasses = new String[auxOCs.size()];
        auxOCs.toArray(this.auxiliaryClasses);
        this.requiredAttributes = new String[reqAttrs.size()];
        reqAttrs.toArray(this.requiredAttributes);
        this.optionalAttributes = new String[optAttrs.size()];
        optAttrs.toArray(this.optionalAttributes);
        this.prohibitedAttributes = new String[notAttrs.size()];
        notAttrs.toArray(this.prohibitedAttributes);
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public DITContentRuleDefinition(String oid, String[] names, String description, boolean isObsolete, String[] auxiliaryClasses, String[] requiredAttributes, String[] optionalAttributes, String[] prohibitedAttributes, Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.isObsolete = isObsolete;
        this.description = description;
        this.names = names == null ? NO_STRINGS : names;
        this.auxiliaryClasses = auxiliaryClasses == null ? NO_STRINGS : auxiliaryClasses;
        this.requiredAttributes = requiredAttributes == null ? NO_STRINGS : requiredAttributes;
        this.optionalAttributes = optionalAttributes == null ? NO_STRINGS : optionalAttributes;
        this.prohibitedAttributes = prohibitedAttributes == null ? NO_STRINGS : prohibitedAttributes;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.ditContentRuleString = buffer.toString();
    }

    private void createDefinitionString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            DITContentRuleDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.auxiliaryClasses.length == 1) {
            buffer.append(" AUX ");
            buffer.append(this.auxiliaryClasses[0]);
        } else if (this.auxiliaryClasses.length > 1) {
            buffer.append(" AUX (");
            for (int i = 0; i < this.auxiliaryClasses.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.auxiliaryClasses[i]);
            }
            buffer.append(" )");
        }
        if (this.requiredAttributes.length == 1) {
            buffer.append(" MUST ");
            buffer.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            buffer.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.requiredAttributes[i]);
            }
            buffer.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            buffer.append(" MAY ");
            buffer.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            buffer.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.optionalAttributes[i]);
            }
            buffer.append(" )");
        }
        if (this.prohibitedAttributes.length == 1) {
            buffer.append(" NOT ");
            buffer.append(this.prohibitedAttributes[0]);
        } else if (this.prohibitedAttributes.length > 1) {
            buffer.append(" NOT (");
            for (int i = 0; i < this.prohibitedAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.prohibitedAttributes[i]);
            }
            buffer.append(" )");
        }
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                DITContentRuleDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                DITContentRuleDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public String[] getProhibitedAttributes() {
        return this.prohibitedAttributes;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public String toString() {
        return this.ditContentRuleString;
    }
}

