/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RDN
implements Comparable<RDN>,
Comparator<RDN>,
Serializable {
    private static final long serialVersionUID = 2923419812807188487L;
    private final ASN1OctetString[] attributeValues;
    private volatile String normalizedString;
    private volatile String rdnString;
    private final String[] attributeNames;

    public RDN(String attributeName, String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
    }

    public RDN(String attributeName, byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
    }

    public RDN(String[] attributeNames, String[] attributeValues) {
        Validator.ensureNotNull(attributeNames, attributeValues);
        Validator.ensureTrue(attributeNames.length == attributeValues.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(attributeNames.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = attributeNames;
        this.attributeValues = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(attributeValues[i]);
        }
    }

    public RDN(String[] attributeNames, byte[][] attributeValues) {
        Validator.ensureNotNull(attributeNames, attributeValues);
        Validator.ensureTrue(attributeNames.length == attributeValues.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(attributeNames.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = attributeNames;
        this.attributeValues = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(attributeValues[i]);
        }
    }

    RDN(String attributeName, ASN1OctetString attributeValue) {
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{attributeValue};
    }

    RDN(String[] attributeNames, ASN1OctetString[] attributeValues) {
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
    }

    public RDN(String rdnString) throws LDAPException {
        ASN1OctetString value;
        char c;
        int pos;
        Validator.ensureNotNull(rdnString);
        this.rdnString = rdnString;
        int length = rdnString.length();
        for (pos = 0; pos < length && rdnString.charAt(pos) == ' '; ++pos) {
        }
        int attrStartPos = pos;
        while (pos < length && (c = rdnString.charAt(pos)) != ' ' && c != '=') {
            ++pos;
        }
        String attrName = rdnString.substring(attrStartPos, pos);
        if (attrName.length() == 0) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get());
        }
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length || rdnString.charAt(pos) != '=') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(attrName));
        }
        ++pos;
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_VALUE.get(attrName));
        }
        if (rdnString.charAt(pos) == '#') {
            byte[] valueArray = RDN.readHexString(rdnString, ++pos);
            value = new ASN1OctetString(valueArray);
            pos += valueArray.length * 2;
        } else {
            StringBuilder buffer = new StringBuilder();
            pos = RDN.readValueString(rdnString, pos, buffer);
            value = new ASN1OctetString(buffer.toString());
        }
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            this.attributeNames = new String[]{attrName};
            this.attributeValues = new ASN1OctetString[]{value};
            return;
        }
        ArrayList<String> nameList = new ArrayList<String>(5);
        ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(5);
        nameList.add(attrName);
        valueList.add(value);
        if (rdnString.charAt(pos) != '+') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get());
        }
        if (++pos >= length) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get());
        }
        int numValues = 1;
        while (pos < length) {
            char c2;
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            attrStartPos = pos;
            while (pos < length && (c2 = rdnString.charAt(pos)) != ' ' && c2 != '=') {
                ++pos;
            }
            attrName = rdnString.substring(attrStartPos, pos);
            if (attrName.length() == 0) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get());
            }
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length || rdnString.charAt(pos) != '=') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(attrName));
            }
            ++pos;
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_VALUE.get(attrName));
            }
            if (rdnString.charAt(pos) == '#') {
                byte[] valueArray = RDN.readHexString(rdnString, ++pos);
                value = new ASN1OctetString(valueArray);
                pos += valueArray.length * 2;
            } else {
                StringBuilder buffer = new StringBuilder();
                pos = RDN.readValueString(rdnString, pos, buffer);
                value = new ASN1OctetString(buffer.toString());
            }
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            nameList.add(attrName);
            valueList.add(value);
            ++numValues;
            if (pos >= length) break;
            if (rdnString.charAt(pos) != '+') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get());
            }
            if (++pos < length) continue;
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get());
        }
        this.attributeNames = new String[numValues];
        this.attributeValues = new ASN1OctetString[numValues];
        for (int i = 0; i < numValues; ++i) {
            this.attributeNames[i] = (String)nameList.get(i);
            this.attributeValues[i] = (ASN1OctetString)valueList.get(i);
        }
    }

    static byte[] readHexString(String rdnString, int startPos) throws LDAPException {
        int length = rdnString.length();
        int pos = startPos;
        ByteBuffer buffer = ByteBuffer.allocate(length - pos);
        block37: while (pos < length) {
            byte hexByte;
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    hexByte = 0;
                    break;
                }
                case '1': {
                    hexByte = 16;
                    break;
                }
                case '2': {
                    hexByte = 32;
                    break;
                }
                case '3': {
                    hexByte = 48;
                    break;
                }
                case '4': {
                    hexByte = 64;
                    break;
                }
                case '5': {
                    hexByte = 80;
                    break;
                }
                case '6': {
                    hexByte = 96;
                    break;
                }
                case '7': {
                    hexByte = 112;
                    break;
                }
                case '8': {
                    hexByte = -128;
                    break;
                }
                case '9': {
                    hexByte = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    hexByte = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    hexByte = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    hexByte = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    hexByte = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    hexByte = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    hexByte = -16;
                    break;
                }
                case ' ': 
                case '+': 
                case ',': 
                case ';': {
                    break block37;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get());
            }
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    break;
                }
                case '1': {
                    hexByte = (byte)(hexByte | 1);
                    break;
                }
                case '2': {
                    hexByte = (byte)(hexByte | 2);
                    break;
                }
                case '3': {
                    hexByte = (byte)(hexByte | 3);
                    break;
                }
                case '4': {
                    hexByte = (byte)(hexByte | 4);
                    break;
                }
                case '5': {
                    hexByte = (byte)(hexByte | 5);
                    break;
                }
                case '6': {
                    hexByte = (byte)(hexByte | 6);
                    break;
                }
                case '7': {
                    hexByte = (byte)(hexByte | 7);
                    break;
                }
                case '8': {
                    hexByte = (byte)(hexByte | 8);
                    break;
                }
                case '9': {
                    hexByte = (byte)(hexByte | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    hexByte = (byte)(hexByte | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    hexByte = (byte)(hexByte | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    hexByte = (byte)(hexByte | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    hexByte = (byte)(hexByte | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    hexByte = (byte)(hexByte | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    hexByte = (byte)(hexByte | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            buffer.put(hexByte);
        }
        buffer.flip();
        byte[] valueArray = new byte[buffer.limit()];
        buffer.get(valueArray);
        return valueArray;
    }

    static int readValueString(String rdnString, int startPos, StringBuilder buffer) throws LDAPException {
        int pos;
        int bufferLength = buffer.length();
        int length = rdnString.length();
        boolean inQuotes = false;
        block6: for (pos = startPos; pos < length; ++pos) {
            char c = rdnString.charAt(pos);
            switch (c) {
                case '\\': {
                    if (pos + 1 >= length) {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_ENDS_WITH_BACKSLASH.get());
                    }
                    if (StaticUtils.isHex(c = rdnString.charAt(++pos))) {
                        pos = RDN.readEscapedHexString(rdnString, pos, buffer) - 1;
                        continue block6;
                    }
                    buffer.append(c);
                    continue block6;
                }
                case '\"': {
                    if (inQuotes) {
                        ++pos;
                        while (pos < length && (c = rdnString.charAt(pos)) != '+' && c != ',' && c != ';') {
                            if (c != ' ') {
                                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_CHAR_OUTSIDE_QUOTES.get(Character.valueOf(c), pos - 1));
                            }
                            ++pos;
                        }
                        inQuotes = false;
                        break block6;
                    }
                    if (pos == startPos) {
                        inQuotes = true;
                        continue block6;
                    }
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNEXPECTED_DOUBLE_QUOTE.get(pos));
                }
                case ' ': {
                    if (!inQuotes && (pos + 1 >= length || rdnString.charAt(pos + 1) == ' ')) continue block6;
                    buffer.append(' ');
                    continue block6;
                }
                case '+': 
                case ',': 
                case ';': {
                    if (!inQuotes) break block6;
                    buffer.append(c);
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (inQuotes) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNCLOSED_DOUBLE_QUOTE.get());
        }
        int bufferPos = buffer.length() - 1;
        int rdnStrPos = pos - 2;
        while (bufferPos > 0 && buffer.charAt(bufferPos) == ' ' && rdnString.charAt(rdnStrPos) != '\\') {
            buffer.deleteCharAt(bufferPos--);
            --rdnStrPos;
        }
        if (buffer.length() == bufferLength) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_EMPTY_VALUE.get());
        }
        return pos;
    }

    private static int readEscapedHexString(String rdnString, int startPos, StringBuilder buffer) throws LDAPException {
        int pos;
        int length = rdnString.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(length - pos);
        for (pos = startPos; pos < length; ++pos) {
            byte b;
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    b = 0;
                    break;
                }
                case '1': {
                    b = 16;
                    break;
                }
                case '2': {
                    b = 32;
                    break;
                }
                case '3': {
                    b = 48;
                    break;
                }
                case '4': {
                    b = 64;
                    break;
                }
                case '5': {
                    b = 80;
                    break;
                }
                case '6': {
                    b = 96;
                    break;
                }
                case '7': {
                    b = 112;
                    break;
                }
                case '8': {
                    b = -128;
                    break;
                }
                case '9': {
                    b = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    b = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    b = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    b = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    b = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    b = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    b = -16;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get());
            }
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    break;
                }
                case '1': {
                    b = (byte)(b | 1);
                    break;
                }
                case '2': {
                    b = (byte)(b | 2);
                    break;
                }
                case '3': {
                    b = (byte)(b | 3);
                    break;
                }
                case '4': {
                    b = (byte)(b | 4);
                    break;
                }
                case '5': {
                    b = (byte)(b | 5);
                    break;
                }
                case '6': {
                    b = (byte)(b | 6);
                    break;
                }
                case '7': {
                    b = (byte)(b | 7);
                    break;
                }
                case '8': {
                    b = (byte)(b | 8);
                    break;
                }
                case '9': {
                    b = (byte)(b | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    b = (byte)(b | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    b = (byte)(b | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    b = (byte)(b | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    b = (byte)(b | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    b = (byte)(b | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    b = (byte)(b | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            byteBuffer.put(b);
            if (pos + 1 >= length || rdnString.charAt(pos) != '\\' || !StaticUtils.isHex(rdnString.charAt(pos + 1))) break;
        }
        byteBuffer.flip();
        byte[] byteArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byteArray);
        try {
            buffer.append(StaticUtils.toUTF8String(byteArray));
        }
        catch (Exception e) {
            Debug.debugException(e);
            buffer.append(new String(byteArray));
        }
        return pos;
    }

    public static boolean isValidRDN(String s) {
        try {
            new RDN(s);
            return true;
        }
        catch (LDAPException le) {
            return false;
        }
    }

    public boolean isMultiValued() {
        return this.attributeNames.length != 1;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public String[] getAttributeValues() {
        String[] stringValues = new String[this.attributeValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = this.attributeValues[i].stringValue();
        }
        return stringValues;
    }

    public byte[][] getByteArrayAttributeValues() {
        byte[][] byteValues = new byte[this.attributeValues.length][];
        for (int i = 0; i < byteValues.length; ++i) {
            byteValues[i] = this.attributeValues[i].getValue();
        }
        return byteValues;
    }

    public boolean hasAttribute(String attributeName) {
        for (String name : this.attributeNames) {
            if (!name.equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String attributeName, String attributeValue) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            Attribute b;
            Attribute a;
            if (!this.attributeNames[i].equalsIgnoreCase(attributeName) || !(a = new Attribute(attributeName, attributeValue)).equals(b = new Attribute(attributeName, this.attributeValues[i].stringValue()))) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String attributeName, byte[] attributeValue) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            Attribute b;
            Attribute a;
            if (!this.attributeNames[i].equalsIgnoreCase(attributeName) || !(a = new Attribute(attributeName, attributeValue)).equals(b = new Attribute(attributeName, this.attributeValues[i].getValue()))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.rdnString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            this.rdnString = buffer.toString();
        }
        return this.rdnString;
    }

    public void toString(StringBuilder buffer) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i > 0) {
                buffer.append('+');
            }
            buffer.append(this.attributeNames[i]);
            buffer.append('=');
            String valueString = this.attributeValues[i].stringValue();
            int length = valueString.length();
            block5: for (int j = 0; j < length; ++j) {
                char c = valueString.charAt(j);
                switch (c) {
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        buffer.append('\\');
                        buffer.append(c);
                        continue block5;
                    }
                    case ' ': {
                        if (j == 0 || j + 1 == length || j + 1 < length && valueString.charAt(j + 1) == ' ') {
                            buffer.append("\\ ");
                            continue block5;
                        }
                        buffer.append(' ');
                        continue block5;
                    }
                    default: {
                        if (c < ' ' || c > '~') {
                            StaticUtils.hexEncode(c, buffer);
                            continue block5;
                        }
                        buffer.append(c);
                    }
                }
            }
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder buffer) {
        if (this.attributeNames.length == 1) {
            buffer.append(StaticUtils.toLowerCase(this.attributeNames[0]));
            buffer.append('=');
            buffer.append((CharSequence)RDN.normalizeValue(this.attributeValues[0]));
        } else {
            int i;
            TreeMap<String, ASN1OctetString> valueMap = new TreeMap<String, ASN1OctetString>();
            for (i = 0; i < this.attributeNames.length; ++i) {
                valueMap.put(StaticUtils.toLowerCase(this.attributeNames[i]), this.attributeValues[i]);
            }
            i = 0;
            for (Map.Entry entry : valueMap.entrySet()) {
                if (i++ > 0) {
                    buffer.append('+');
                }
                buffer.append((String)entry.getKey());
                buffer.append('=');
                buffer.append((CharSequence)RDN.normalizeValue((ASN1OctetString)entry.getValue()));
            }
        }
    }

    public static String normalize(String s) throws LDAPException {
        return new RDN(s).toNormalizedString();
    }

    private static StringBuilder normalizeValue(ASN1OctetString value) {
        String valueString = value.stringValue();
        int length = valueString.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = valueString.charAt(i);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            switch (c) {
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case ' ': {
                    if (i == 0 || i + 1 == length || i + 1 < length && valueString.charAt(i + 1) == ' ') {
                        buffer.append("\\ ");
                        break;
                    }
                    buffer.append(' ');
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        StaticUtils.hexEncode(c, buffer);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if ((c & 0x7F) == c) continue;
        }
        return buffer;
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDN)) {
            return false;
        }
        RDN rdn = (RDN)o;
        return this.toNormalizedString().equals(rdn.toNormalizedString());
    }

    public boolean equals(String s) throws LDAPException {
        if (s == null) {
            return false;
        }
        return this.equals(new RDN(s));
    }

    public static boolean equals(String s1, String s2) throws LDAPException {
        return new RDN(s1).equals(new RDN(s2));
    }

    @Override
    public int compareTo(RDN rdn) {
        return this.compare(this, rdn);
    }

    @Override
    public int compare(RDN rdn1, RDN rdn2) {
        Validator.ensureNotNull(rdn1, rdn2);
        return rdn1.toNormalizedString().compareTo(rdn2.toNormalizedString());
    }

    public static int compare(String s1, String s2) throws LDAPException {
        return new RDN(s1).compareTo(new RDN(s2));
    }
}

