/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttribute;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttributeSet;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPEntry
implements Serializable {
    private static final long serialVersionUID = -6285850560316222689L;
    private final String dn;
    private final LDAPAttributeSet attributeSet;

    public LDAPEntry() {
        this("", new LDAPAttributeSet());
    }

    public LDAPEntry(String distinguishedName) {
        this(distinguishedName, new LDAPAttributeSet());
    }

    public LDAPEntry(String distinguishedName, LDAPAttributeSet attrs) {
        this.dn = distinguishedName;
        this.attributeSet = attrs == null ? new LDAPAttributeSet() : attrs;
    }

    public LDAPEntry(Entry entry) {
        this.dn = entry.getDN();
        this.attributeSet = new LDAPAttributeSet();
        for (Attribute a : entry.getAttributes()) {
            this.attributeSet.add(new LDAPAttribute(a));
        }
    }

    public String getDN() {
        return this.dn;
    }

    public LDAPAttributeSet getAttributeSet() {
        return this.attributeSet;
    }

    public LDAPAttributeSet getAttributeSet(String subtype) {
        return this.attributeSet.getSubset(subtype);
    }

    public LDAPAttribute getAttribute(String attrName) {
        return this.attributeSet.getAttribute(attrName);
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        return this.attributeSet.getAttribute(attrName, lang);
    }

    public final Entry toEntry() {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        Enumeration<LDAPAttribute> attrEnum = this.attributeSet.getAttributes();
        while (attrEnum.hasMoreElements()) {
            attrs.add(attrEnum.nextElement().toAttribute());
        }
        return new Entry(this.dn, attrs);
    }

    public String toString() {
        return this.toEntry().toString();
    }
}

