/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ColumnFormatter
implements Serializable {
    private static final OutputFormat DEFAULT_OUTPUT_FORMAT = OutputFormat.COLUMNS;
    private static final String DEFAULT_SPACER = " ";
    private static final String DEFAULT_TIMESTAMP_FORMAT = "HH:mm:ss";
    private static final long serialVersionUID = -2524398424293401200L;
    private final boolean includeTimestamp;
    private final FormattableColumn timestampColumn;
    private final FormattableColumn[] columns;
    private final OutputFormat outputFormat;
    private final String spacer;
    private final String timestampFormat;
    private final transient ThreadLocal<DecimalFormat> decimalFormatter;
    private final transient ThreadLocal<SimpleDateFormat> timestampFormatter;

    public ColumnFormatter(FormattableColumn ... columns) {
        this(false, null, null, null, columns);
    }

    public ColumnFormatter(boolean includeTimestamp, String timestampFormat, OutputFormat outputFormat, String spacer, FormattableColumn ... columns) {
        Validator.ensureNotNull(columns);
        Validator.ensureTrue(columns.length > 0);
        this.includeTimestamp = includeTimestamp;
        this.columns = columns;
        this.decimalFormatter = new ThreadLocal();
        this.timestampFormatter = new ThreadLocal();
        this.timestampFormat = timestampFormat == null ? DEFAULT_TIMESTAMP_FORMAT : timestampFormat;
        this.outputFormat = outputFormat == null ? DEFAULT_OUTPUT_FORMAT : outputFormat;
        this.spacer = spacer == null ? DEFAULT_SPACER : spacer;
        if (includeTimestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampFormat);
            String timestamp = dateFormat.format(new Date());
            String label = UtilityMessages.INFO_COLUMN_LABEL_TIMESTAMP.get();
            int width = Math.max(label.length(), timestamp.length());
            this.timestampFormatter.set(dateFormat);
            this.timestampColumn = new FormattableColumn(width, HorizontalAlignment.LEFT, label);
        } else {
            this.timestampColumn = null;
        }
    }

    public boolean includeTimestamps() {
        return this.includeTimestamp;
    }

    public String getTimestampFormatString() {
        return this.timestampFormat;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public String getSpacer() {
        return this.spacer;
    }

    public FormattableColumn[] getColumns() {
        FormattableColumn[] copy = new FormattableColumn[this.columns.length];
        System.arraycopy(this.columns, 0, copy, 0, this.columns.length);
        return copy;
    }

    public String[] getHeaderLines(boolean includeDashes) {
        if (this.outputFormat == OutputFormat.COLUMNS) {
            int maxColumns = 1;
            String[][] headerLines = new String[this.columns.length][];
            for (int i = 0; i < this.columns.length; ++i) {
                headerLines[i] = this.columns[i].getLabelLines();
                maxColumns = Math.max(maxColumns, headerLines[i].length);
            }
            StringBuilder[] buffers = new StringBuilder[maxColumns];
            for (int i = 0; i < maxColumns; ++i) {
                StringBuilder buffer;
                buffers[i] = buffer = new StringBuilder();
                if (this.includeTimestamp) {
                    if (i == maxColumns - 1) {
                        this.timestampColumn.format(buffer, this.timestampColumn.getSingleLabelLine(), this.outputFormat);
                    } else {
                        this.timestampColumn.format(buffer, "", this.outputFormat);
                    }
                }
                for (int j = 0; j < this.columns.length; ++j) {
                    int rowNumber;
                    if (this.includeTimestamp || j > 0) {
                        buffer.append(this.spacer);
                    }
                    if ((rowNumber = i + headerLines[j].length - maxColumns) < 0) {
                        this.columns[j].format(buffer, "", this.outputFormat);
                        continue;
                    }
                    this.columns[j].format(buffer, headerLines[j][rowNumber], this.outputFormat);
                }
            }
            String[] returnArray = includeDashes ? new String[maxColumns + 1] : new String[maxColumns];
            for (int i = 0; i < maxColumns; ++i) {
                returnArray[i] = buffers[i].toString();
            }
            if (includeDashes) {
                int i;
                StringBuilder buffer = new StringBuilder();
                if (this.timestampColumn != null) {
                    for (i = 0; i < this.timestampColumn.getWidth(); ++i) {
                        buffer.append('-');
                    }
                }
                for (i = 0; i < this.columns.length; ++i) {
                    if (this.includeTimestamp || i > 0) {
                        buffer.append(this.spacer);
                    }
                    for (int j = 0; j < this.columns[i].getWidth(); ++j) {
                        buffer.append('-');
                    }
                }
                returnArray[returnArray.length - 1] = buffer.toString();
            }
            return returnArray;
        }
        StringBuilder buffer = new StringBuilder();
        if (this.timestampColumn != null) {
            this.timestampColumn.format(buffer, this.timestampColumn.getSingleLabelLine(), this.outputFormat);
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.includeTimestamp || i > 0) {
                if (this.outputFormat == OutputFormat.TAB_DELIMITED_TEXT) {
                    buffer.append('\t');
                } else if (this.outputFormat == OutputFormat.CSV) {
                    buffer.append(',');
                }
            }
            FormattableColumn c = this.columns[i];
            c.format(buffer, c.getSingleLabelLine(), this.outputFormat);
        }
        return new String[]{buffer.toString()};
    }

    public String formatRow(Object ... columnData) {
        StringBuilder buffer = new StringBuilder();
        if (this.includeTimestamp) {
            SimpleDateFormat dateFormat = this.timestampFormatter.get();
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(this.timestampFormat);
                this.timestampFormatter.set(dateFormat);
            }
            this.timestampColumn.format(buffer, dateFormat.format(new Date()), this.outputFormat);
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.includeTimestamp || i > 0) {
                switch (this.outputFormat) {
                    case TAB_DELIMITED_TEXT: {
                        buffer.append('\t');
                        break;
                    }
                    case CSV: {
                        buffer.append(',');
                        break;
                    }
                    case COLUMNS: {
                        buffer.append(this.spacer);
                    }
                }
            }
            if (i >= columnData.length) {
                this.columns[i].format(buffer, "", this.outputFormat);
                continue;
            }
            this.columns[i].format(buffer, this.toString(columnData[i]), this.outputFormat);
        }
        return buffer.toString();
    }

    private String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Float || o instanceof Double) {
            DecimalFormat f = this.decimalFormatter.get();
            if (f == null) {
                f = new DecimalFormat("0.000");
                this.decimalFormatter.set(f);
            }
            double d = o instanceof Float ? ((Float)o).doubleValue() : ((Double)o).doubleValue();
            return f.format(d);
        }
        return String.valueOf(o);
    }
}

