/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.AcceptAllSimpleMatchingRule;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CaseExactStringMatchingRule
extends AcceptAllSimpleMatchingRule {
    private static final CaseExactStringMatchingRule INSTANCE = new CaseExactStringMatchingRule();
    public static final String EQUALITY_RULE_NAME = "caseExactMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("caseExactMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.5";
    public static final String ORDERING_RULE_NAME = "caseExactOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("caseExactOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.6";
    public static final String SUBSTRING_RULE_NAME = "caseExactSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("caseExactSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.7";
    private static final long serialVersionUID = -6336492464430413364L;

    public static CaseExactStringMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    public boolean valuesMatch(ASN1OctetString value1, ASN1OctetString value2) {
        byte[] value2Bytes;
        byte[] value1Bytes = value1.getValue();
        if (value1Bytes.length == (value2Bytes = value2.getValue()).length) {
            for (int i = 0; i < value1Bytes.length; ++i) {
                byte b1 = value1Bytes[i];
                byte b2 = value2Bytes[i];
                if ((b1 & 0x7F) != (b1 & 0xFF) || (b2 & 0x7F) != (b2 & 0xFF)) {
                    return this.normalize(value1).equals(this.normalize(value2));
                }
                if (b1 == b2) continue;
                if (b1 == 32 || b2 == 32) {
                    return this.normalize(value1).equals(this.normalize(value2));
                }
                return false;
            }
            return true;
        }
        return CaseExactStringMatchingRule.normalizeInternal(value1, false, (byte)0).equals(CaseExactStringMatchingRule.normalizeInternal(value2, false, (byte)0));
    }

    public ASN1OctetString normalize(ASN1OctetString value) {
        return CaseExactStringMatchingRule.normalizeInternal(value, false, (byte)0);
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) {
        return CaseExactStringMatchingRule.normalizeInternal(value, true, substringType);
    }

    private static ASN1OctetString normalizeInternal(ASN1OctetString value, boolean isSubstring, byte substringType) {
        boolean trimFinal;
        boolean trimInitial;
        byte[] valueBytes = value.getValue();
        if (valueBytes.length == 0) {
            return value;
        }
        if (isSubstring) {
            switch (substringType) {
                case -128: {
                    trimInitial = true;
                    trimFinal = false;
                    break;
                }
                case -126: {
                    trimInitial = false;
                    trimFinal = true;
                    break;
                }
                default: {
                    trimInitial = false;
                    trimFinal = false;
                    break;
                }
            }
        } else {
            trimInitial = true;
            trimFinal = true;
        }
        boolean containsNonSpace = false;
        boolean lastWasSpace = trimInitial;
        int numDuplicates = 0;
        for (byte b : valueBytes) {
            if ((b & 0x7F) != (b & 0xFF)) {
                return CaseExactStringMatchingRule.normalizeNonASCII(value, trimInitial, trimFinal);
            }
            if (b == 32) {
                if (lastWasSpace) {
                    ++numDuplicates;
                    continue;
                }
                lastWasSpace = true;
                continue;
            }
            containsNonSpace = true;
            lastWasSpace = false;
        }
        if (!containsNonSpace) {
            return new ASN1OctetString(" ");
        }
        if (lastWasSpace && trimFinal) {
            ++numDuplicates;
        }
        lastWasSpace = trimInitial;
        int targetPos = 0;
        byte[] normalizedBytes = new byte[valueBytes.length - numDuplicates];
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 32) {
                if (lastWasSpace || trimFinal && i == valueBytes.length - 1 || targetPos >= normalizedBytes.length) continue;
                normalizedBytes[targetPos++] = 32;
                lastWasSpace = true;
                continue;
            }
            normalizedBytes[targetPos++] = valueBytes[i];
            lastWasSpace = false;
        }
        return new ASN1OctetString(normalizedBytes);
    }

    private static ASN1OctetString normalizeNonASCII(ASN1OctetString value, boolean trimInitial, boolean trimFinal) {
        StringBuilder buffer = new StringBuilder(value.stringValue());
        int pos = 0;
        boolean lastWasSpace = trimInitial;
        while (pos < buffer.length()) {
            char c;
            if (Character.isSpaceChar(c = buffer.charAt(pos++))) {
                if (lastWasSpace || trimFinal && pos >= buffer.length()) {
                    buffer.deleteCharAt(--pos);
                    continue;
                }
                lastWasSpace = true;
                continue;
            }
            lastWasSpace = false;
        }
        if (trimFinal && Character.isSpaceChar(buffer.charAt(buffer.length() - 1))) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return new ASN1OctetString(buffer.toString());
    }
}

