/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class AuthRateThread
extends Thread {
    private static final int AUTH_TYPE_SIMPLE = 0;
    private static final int AUTH_TYPE_CRAM_MD5 = 1;
    private static final int AUTH_TYPE_DIGEST_MD5 = 2;
    private static final int AUTH_TYPE_PLAIN = 3;
    private final AtomicBoolean stopRequested;
    private final AtomicLong authCounter;
    private final AtomicLong authDurations;
    private final AtomicLong errorCounter;
    private final AtomicReference<ResultCode> resultCode;
    private final AtomicReference<Thread> authThread;
    private final CyclicBarrier startBarrier;
    private final int authType;
    private final LDAPConnection bindConnection;
    private final LDAPConnection searchConnection;
    private final ResultCodeCounter rcCounter;
    private final SearchRequest searchRequest;
    private final String userPassword;
    private final ValuePattern baseDN;
    private final ValuePattern filter;
    private final FixedRateBarrier fixedRateBarrier;

    AuthRateThread(int threadNumber, LDAPConnection searchConnection, LDAPConnection bindConnection, ValuePattern baseDN, SearchScope scope, ValuePattern filter, String[] attributes, String userPassword, String authType, CyclicBarrier startBarrier, AtomicLong authCounter, AtomicLong authDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier) {
        this.setName("AuthRate Thread " + threadNumber);
        this.setDaemon(true);
        this.searchConnection = searchConnection;
        this.bindConnection = bindConnection;
        this.baseDN = baseDN;
        this.filter = filter;
        this.userPassword = userPassword;
        this.authCounter = authCounter;
        this.authDurations = authDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        searchConnection.setConnectionName("search-" + threadNumber);
        bindConnection.setConnectionName("bind-" + threadNumber);
        this.authType = authType.equalsIgnoreCase("cram-md5") ? 1 : (authType.equalsIgnoreCase("digest-md5") ? 2 : (authType.equalsIgnoreCase("plain") ? 3 : 0));
        this.resultCode = new AtomicReference<Object>(null);
        this.authThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.searchRequest = new SearchRequest("", scope, Filter.createPresenceFilter("objectClass"), attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.authThread.set(AuthRateThread.currentThread());
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        block21: while (!this.stopRequested.get()) {
            try {
                this.searchRequest.setBaseDN(this.baseDN.nextValue());
                this.searchRequest.setFilter(this.filter.nextValue());
            }
            catch (LDAPException le) {
                this.errorCounter.incrementAndGet();
                ResultCode rc = le.getResultCode();
                this.rcCounter.increment(rc);
                this.resultCode.compareAndSet(null, rc);
                continue;
            }
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.await();
            }
            long startTime = System.nanoTime();
            try {
                SearchResult r = this.searchConnection.search(this.searchRequest);
                switch (r.getEntryCount()) {
                    case 0: {
                        this.errorCounter.incrementAndGet();
                        this.rcCounter.increment(ResultCode.NO_RESULTS_RETURNED);
                        this.resultCode.compareAndSet(null, ResultCode.NO_RESULTS_RETURNED);
                        continue block21;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.errorCounter.incrementAndGet();
                        this.rcCounter.increment(ResultCode.MORE_RESULTS_TO_RETURN);
                        this.resultCode.compareAndSet(null, ResultCode.MORE_RESULTS_TO_RETURN);
                        continue block21;
                    }
                }
                BindRequest bindRequest = null;
                String dn = r.getSearchEntries().get(0).getDN();
                switch (this.authType) {
                    case 0: {
                        bindRequest = new SimpleBindRequest(dn, this.userPassword);
                        break;
                    }
                    case 1: {
                        bindRequest = new CRAMMD5BindRequest("dn:" + dn, this.userPassword);
                        break;
                    }
                    case 2: {
                        bindRequest = new DIGESTMD5BindRequest("dn:" + dn, this.userPassword);
                        break;
                    }
                    case 3: {
                        bindRequest = new PLAINBindRequest("dn:" + dn, this.userPassword);
                    }
                }
                this.bindConnection.bind(bindRequest);
            }
            catch (LDAPException le) {
                this.errorCounter.incrementAndGet();
                ResultCode rc = le.getResultCode();
                this.rcCounter.increment(rc);
                this.resultCode.compareAndSet(null, rc);
            }
            finally {
                this.authCounter.incrementAndGet();
                this.authDurations.addAndGet(System.nanoTime() - startTime);
            }
        }
        this.searchConnection.close();
        this.bindConnection.close();
        this.authThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.authThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

