/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_NOT_THREADSAFE)
public final class WakeableSleeper
implements Serializable {
    private static final Object WAKEUP_OBJECT = new Object();
    private static final long serialVersionUID = 4758449685424440579L;
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private final AtomicBoolean sleeping = new AtomicBoolean(false);

    @ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
    public boolean sleep(long time) {
        Validator.ensureTrue(this.sleeping.compareAndSet(false, true), "WakeableSleeper.sleep() must not be invoked concurrently by multiple threads against the same instance.");
        boolean completed = false;
        try {
            this.queue.poll();
            completed = this.queue.poll(time, TimeUnit.MILLISECONDS) == null;
        }
        catch (InterruptedException ie) {
            Debug.debugException(ie);
        }
        this.sleeping.set(false);
        return completed;
    }

    @ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
    public void wakeup() {
        this.queue.offer(WAKEUP_OBJECT);
    }
}

