/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StringArgument
extends Argument {
    private static final long serialVersionUID = 1088032496970585118L;
    private final ArrayList<String> values;
    private final List<String> defaultValues;
    private final Set<String> allowedValues;

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, null, (List<String>)null);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Set<String> allowedValues) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, allowedValues, (List<String>)null);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, String defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, null, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, List<String> defaultValues) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, null, defaultValues);
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Set<String> allowedValues, String defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, allowedValues, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public StringArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Set<String> allowedValues, List<String> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        if (allowedValues == null || allowedValues.isEmpty()) {
            this.allowedValues = null;
        } else {
            HashSet<String> lowerValues = new HashSet<String>(allowedValues.size());
            for (String s : allowedValues) {
                lowerValues.add(StaticUtils.toLowerCase(s));
            }
            this.allowedValues = Collections.unmodifiableSet(lowerValues);
        }
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList();
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        String lowerValue = StaticUtils.toLowerCase(valueString);
        if (this.allowedValues != null && !this.allowedValues.contains(lowerValue)) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_VALUE_NOT_ALLOWED.get(valueString, this.getIdentifierString()));
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        this.values.add(valueString);
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }
}

