/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GSSAPIBindRequest
extends SASLBindRequest
implements CallbackHandler,
PrivilegedExceptionAction<Object> {
    public static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String PROPERTY_KDC_ADDRESS = "java.security.krb5.kdc";
    private static final String PROPERTY_REALM = "java.security.krb5.realm";
    private static final String PROPERTY_CONFIG_FILE = "java.security.auth.login.config";
    private static final String PROPERTY_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final AtomicReference<String> DEFAULT_CONFIG_FILE_PATH = new AtomicReference();
    private static final String JAAS_CLIENT_NAME = "GSSAPIBindRequest";
    private static final long serialVersionUID = 2511890818146955112L;
    private final ASN1OctetString password;
    private final AtomicReference<LDAPConnection> conn;
    private int messageID = -1;
    private final String authenticationID;
    private final String authorizationID;
    private final String configFilePath;
    private final String kdcAddress;
    private final String realm;

    public GSSAPIBindRequest(String authenticationID, String password) throws LDAPException {
        this(authenticationID, null, password, null, null, null, null);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password) throws LDAPException {
        this(authenticationID, null, password, null, null, null, null);
    }

    public GSSAPIBindRequest(String authenticationID, String password, Control[] controls) throws LDAPException {
        this(authenticationID, null, password, null, null, null, controls);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password, Control[] controls) throws LDAPException {
        this(authenticationID, null, password, null, null, null, controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath, null);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath, null);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath, controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath, controls);
    }

    private GSSAPIBindRequest(String authenticationID, String authorizationID, ASN1OctetString password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        super(controls);
        Validator.ensureNotNull(authenticationID, password);
        this.authenticationID = authenticationID;
        this.password = password;
        this.realm = realm;
        this.kdcAddress = kdcAddress;
        this.conn = new AtomicReference();
        this.authorizationID = authorizationID == null ? authenticationID : authorizationID;
        this.configFilePath = configFilePath == null ? GSSAPIBindRequest.getDefaultConfigFilePath() : configFilePath;
    }

    @Override
    public String getSASLMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getPasswordString() {
        return this.password.stringValue();
    }

    public byte[] getPasswordBytes() {
        return this.password.getValue();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getKDCAddress() {
        return this.kdcAddress;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultConfigFilePath() throws LDAPException {
        try {
            String value = DEFAULT_CONFIG_FILE_PATH.get();
            if (value == null) {
                File f = File.createTempFile("GSSAPIBindRequest-JAAS-Config-", ".conf");
                f.deleteOnExit();
                PrintWriter w = new PrintWriter(new FileWriter(f));
                try {
                    w.println("GSSAPIBindRequest {");
                    w.println("  com.sun.security.auth.module.Krb5LoginModule required client=true useTicketCache=true;");
                    w.println("};");
                }
                finally {
                    w.close();
                }
                if (!DEFAULT_CONFIG_FILE_PATH.compareAndSet(null, f.getAbsolutePath())) {
                    f.delete();
                }
                value = DEFAULT_CONFIG_FILE_PATH.get();
            }
            return value;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (!this.conn.compareAndSet(null, connection)) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_MULTIPLE_CONCURRENT_REQUESTS.get());
        }
        System.setProperty(PROPERTY_CONFIG_FILE, this.configFilePath);
        System.setProperty(PROPERTY_SUBJECT_CREDS_ONLY, "true");
        if (this.kdcAddress != null) {
            System.setProperty(PROPERTY_KDC_ADDRESS, this.kdcAddress);
        }
        if (this.realm != null) {
            System.setProperty(PROPERTY_REALM, this.realm);
        }
        try {
            LoginContext context;
            try {
                context = new LoginContext(JAAS_CLIENT_NAME, this);
                context.login();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_INITIALIZE_JAAS_CONTEXT.get(StaticUtils.getExceptionMessage(e)), e);
            }
            try {
                BindResult e = (BindResult)Subject.doAs(context.getSubject(), this);
                return e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (e instanceof LDAPException) {
                    throw (LDAPException)e;
                }
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        finally {
            this.conn.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InternalUseOnly
    public Object run() throws LDAPException {
        SaslClient saslClient;
        LDAPConnection connection = this.conn.get();
        String[] mechanisms = new String[]{GSSAPI_MECHANISM_NAME};
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("javax.security.sasl.qop", "auth");
        saslProperties.put("javax.security.sasl.server.authentication", "true");
        try {
            saslClient = Sasl.createSaslClient(mechanisms, this.authorizationID, "ldap", connection.getConnectedAddress(), saslProperties, this);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SASLHelper helper = new SASLHelper(this, connection, GSSAPI_MECHANISM_NAME, saslClient, this.getControls(), this.getResponseTimeoutMillis(connection));
        try {
            BindResult bindResult = helper.processSASLBind();
            return bindResult;
        }
        finally {
            this.messageID = helper.getMessageID();
        }
    }

    @Override
    public GSSAPIBindRequest getRebindRequest(String host, int port) {
        try {
            return new GSSAPIBindRequest(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath, this.getControls());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @InternalUseOnly
    public void handle(Callback[] callbacks) {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.stringValue().toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback) {
                if (this.realm == null) continue;
                ((RealmCallback)callback).setText(this.realm);
                continue;
            }
            if (!Debug.debugEnabled(DebugType.LDAP)) continue;
            Debug.debug(Level.WARNING, DebugType.LDAP, "Unexpected GSSAPI SASL callback of type " + callback.getClass().getName());
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public GSSAPIBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public GSSAPIBindRequest duplicate(Control[] controls) {
        try {
            GSSAPIBindRequest bindRequest = new GSSAPIBindRequest(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath, controls);
            bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
            return bindRequest;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GSSAPIBindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        if (this.kdcAddress != null) {
            buffer.append(", kdcAddress='");
            buffer.append(this.kdcAddress);
            buffer.append('\'');
        }
        buffer.append(", configFilePath='");
        buffer.append(this.configFilePath);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

