/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.LDAPSDKRuntimeException;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StaticUtils {
    public static final byte[] NO_BYTES = new byte[0];
    public static final String EOL = System.getProperty("line.separator");
    public static final byte[] EOL_BYTES = StaticUtils.getBytes(EOL);
    private static final ThreadLocal<SimpleDateFormat> dateFormatters = new ThreadLocal();

    private StaticUtils() {
    }

    public static byte[] getBytes(String s) {
        int length;
        if (s == null || (length = s.length()) == 0) {
            return NO_BYTES;
        }
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                try {
                    return s.getBytes("UTF-8");
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return s.getBytes();
                }
            }
            b[i] = (byte)(c & 0x7F);
        }
        return b;
    }

    public static String toUTF8String(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new String(b);
        }
    }

    public static String toUTF8String(byte[] b, int offset, int length) {
        try {
            return new String(b, offset, length, "UTF-8");
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new String(b, offset, length);
        }
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] charArray = s.toCharArray();
        block28: for (int i = 0; i < length; ++i) {
            switch (charArray[i]) {
                case 'A': {
                    charArray[i] = 97;
                    continue block28;
                }
                case 'B': {
                    charArray[i] = 98;
                    continue block28;
                }
                case 'C': {
                    charArray[i] = 99;
                    continue block28;
                }
                case 'D': {
                    charArray[i] = 100;
                    continue block28;
                }
                case 'E': {
                    charArray[i] = 101;
                    continue block28;
                }
                case 'F': {
                    charArray[i] = 102;
                    continue block28;
                }
                case 'G': {
                    charArray[i] = 103;
                    continue block28;
                }
                case 'H': {
                    charArray[i] = 104;
                    continue block28;
                }
                case 'I': {
                    charArray[i] = 105;
                    continue block28;
                }
                case 'J': {
                    charArray[i] = 106;
                    continue block28;
                }
                case 'K': {
                    charArray[i] = 107;
                    continue block28;
                }
                case 'L': {
                    charArray[i] = 108;
                    continue block28;
                }
                case 'M': {
                    charArray[i] = 109;
                    continue block28;
                }
                case 'N': {
                    charArray[i] = 110;
                    continue block28;
                }
                case 'O': {
                    charArray[i] = 111;
                    continue block28;
                }
                case 'P': {
                    charArray[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    charArray[i] = 113;
                    continue block28;
                }
                case 'R': {
                    charArray[i] = 114;
                    continue block28;
                }
                case 'S': {
                    charArray[i] = 115;
                    continue block28;
                }
                case 'T': {
                    charArray[i] = 116;
                    continue block28;
                }
                case 'U': {
                    charArray[i] = 117;
                    continue block28;
                }
                case 'V': {
                    charArray[i] = 118;
                    continue block28;
                }
                case 'W': {
                    charArray[i] = 119;
                    continue block28;
                }
                case 'X': {
                    charArray[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    charArray[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    charArray[i] = 122;
                    continue block28;
                }
                default: {
                    if (charArray[i] <= '\u007f') continue block28;
                    return s.toLowerCase();
                }
            }
        }
        return new String(charArray);
    }

    public static boolean isHex(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static String toHex(byte b) {
        StringBuilder buffer = new StringBuilder(2);
        StaticUtils.toHex(b, buffer);
        return buffer.toString();
    }

    public static void toHex(byte b, StringBuilder buffer) {
        switch (b & 0xF0) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 16: {
                buffer.append('1');
                break;
            }
            case 32: {
                buffer.append('2');
                break;
            }
            case 48: {
                buffer.append('3');
                break;
            }
            case 64: {
                buffer.append('4');
                break;
            }
            case 80: {
                buffer.append('5');
                break;
            }
            case 96: {
                buffer.append('6');
                break;
            }
            case 112: {
                buffer.append('7');
                break;
            }
            case 128: {
                buffer.append('8');
                break;
            }
            case 144: {
                buffer.append('9');
                break;
            }
            case 160: {
                buffer.append('a');
                break;
            }
            case 176: {
                buffer.append('b');
                break;
            }
            case 192: {
                buffer.append('c');
                break;
            }
            case 208: {
                buffer.append('d');
                break;
            }
            case 224: {
                buffer.append('e');
                break;
            }
            case 240: {
                buffer.append('f');
            }
        }
        switch (b & 0xF) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 1: {
                buffer.append('1');
                break;
            }
            case 2: {
                buffer.append('2');
                break;
            }
            case 3: {
                buffer.append('3');
                break;
            }
            case 4: {
                buffer.append('4');
                break;
            }
            case 5: {
                buffer.append('5');
                break;
            }
            case 6: {
                buffer.append('6');
                break;
            }
            case 7: {
                buffer.append('7');
                break;
            }
            case 8: {
                buffer.append('8');
                break;
            }
            case 9: {
                buffer.append('9');
                break;
            }
            case 10: {
                buffer.append('a');
                break;
            }
            case 11: {
                buffer.append('b');
                break;
            }
            case 12: {
                buffer.append('c');
                break;
            }
            case 13: {
                buffer.append('d');
                break;
            }
            case 14: {
                buffer.append('e');
                break;
            }
            case 15: {
                buffer.append('f');
            }
        }
    }

    public static String toHex(byte[] b) {
        Validator.ensureNotNull(b);
        StringBuilder buffer = new StringBuilder(2 * b.length);
        StaticUtils.toHex(b, buffer);
        return buffer.toString();
    }

    public static void toHex(byte[] b, StringBuilder buffer) {
        for (byte bt : b) {
            StaticUtils.toHex(bt, buffer);
        }
    }

    public static void hexEncode(char c, StringBuilder buffer) {
        byte[] charBytes = c <= '\u007f' ? new byte[]{(byte)(c & 0x7F)} : StaticUtils.getBytes(String.valueOf(c));
        for (byte b : charBytes) {
            buffer.append('\\');
            StaticUtils.toHex(b, buffer);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(t, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(Throwable t, StringBuilder buffer) {
        buffer.append(StaticUtils.getUnqualifiedClassName(t.getClass()));
        buffer.append('(');
        String message = t.getMessage();
        if (message != null) {
            buffer.append("message='");
            buffer.append(message);
            buffer.append("', ");
        }
        buffer.append("trace='");
        StaticUtils.getStackTrace(t.getStackTrace(), buffer);
        buffer.append('\'');
        Throwable cause = t.getCause();
        if (cause != null) {
            buffer.append(", cause=");
            StaticUtils.getStackTrace(cause, buffer);
        }
        buffer.append(", revision=");
        buffer.append(6963L);
        buffer.append(')');
    }

    public static String getStackTrace(StackTraceElement[] elements) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(elements, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(StackTraceElement[] elements, StringBuilder buffer) {
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(" / ");
            }
            buffer.append(elements[i].getMethodName());
            buffer.append('(');
            buffer.append(elements[i].getFileName());
            int lineNumber = elements[i].getLineNumber();
            if (lineNumber > 0) {
                buffer.append(':');
                buffer.append(lineNumber);
            }
            buffer.append(')');
        }
    }

    public static String getExceptionMessage(Throwable t) {
        if (t == null) {
            return UtilityMessages.ERR_NO_EXCEPTION.get();
        }
        StringBuilder buffer = new StringBuilder();
        if (t instanceof LDAPSDKException) {
            buffer.append(((LDAPSDKException)t).getExceptionMessage());
        } else if (t instanceof LDAPSDKRuntimeException) {
            buffer.append(((LDAPSDKRuntimeException)t).getExceptionMessage());
        }
        if (t instanceof RuntimeException || t instanceof Error) {
            return StaticUtils.getStackTrace(t);
        }
        buffer.append(String.valueOf(t));
        Throwable cause = t.getCause();
        if (cause != null) {
            buffer.append(" caused by ");
            buffer.append(StaticUtils.getExceptionMessage(cause));
        }
        return buffer.toString();
    }

    public static String getUnqualifiedClassName(Class<?> c) {
        String className = c.getName();
        int lastPeriodPos = className.lastIndexOf(46);
        if (lastPeriodPos > 0) {
            return className.substring(lastPeriodPos + 1);
        }
        return className;
    }

    public static String encodeGeneralizedTime(Date d) {
        SimpleDateFormat dateFormat = dateFormatters.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormatters.set(dateFormat);
        }
        return dateFormat.format(d);
    }

    public static Date decodeGeneralizedTime(String t) throws ParseException {
        String formatStr;
        String trimmedTimestamp;
        String subSecFormatStr;
        int tzPos;
        TimeZone tz;
        Validator.ensureNotNull(t);
        if (t.endsWith("Z")) {
            tz = TimeZone.getTimeZone("UTC");
            tzPos = t.length() - 1;
        } else {
            tzPos = t.lastIndexOf(45);
            if (tzPos < 0 && (tzPos = t.lastIndexOf(43)) < 0) {
                throw new ParseException(UtilityMessages.ERR_GENTIME_DECODE_CANNOT_PARSE_TZ.get(t), 0);
            }
            tz = TimeZone.getTimeZone("GMT" + t.substring(tzPos));
            if (tz.getRawOffset() == 0 && !t.endsWith("+0000") && !t.endsWith("-0000")) {
                throw new ParseException(UtilityMessages.ERR_GENTIME_DECODE_CANNOT_PARSE_TZ.get(t), tzPos);
            }
        }
        int periodPos = t.lastIndexOf(46, tzPos);
        if (periodPos > 0) {
            int subSecondLength = tzPos - periodPos - 1;
            switch (subSecondLength) {
                case 0: {
                    subSecFormatStr = "";
                    trimmedTimestamp = t.substring(0, periodPos);
                    break;
                }
                case 1: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 2) + "00";
                    break;
                }
                case 2: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 3) + '0';
                    break;
                }
                default: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 4);
                    break;
                }
            }
        } else {
            subSecFormatStr = "";
            periodPos = tzPos;
            trimmedTimestamp = t.substring(0, tzPos);
        }
        switch (periodPos) {
            case 10: {
                formatStr = "yyyyMMddHH" + subSecFormatStr;
                break;
            }
            case 12: {
                formatStr = "yyyyMMddHHmm" + subSecFormatStr;
                break;
            }
            case 14: {
                formatStr = "yyyyMMddHHmmss" + subSecFormatStr;
                break;
            }
            default: {
                throw new ParseException(UtilityMessages.ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH.get(t), periodPos);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        dateFormat.setTimeZone(tz);
        dateFormat.setLenient(false);
        return dateFormat.parse(trimmedTimestamp);
    }

    public static String trimLeading(String s) {
        int nonSpacePos;
        Validator.ensureNotNull(s);
        int length = s.length();
        for (nonSpacePos = 0; nonSpacePos < length && s.charAt(nonSpacePos) == ' '; ++nonSpacePos) {
        }
        if (nonSpacePos == 0) {
            return s;
        }
        if (nonSpacePos >= length) {
            return "";
        }
        return s.substring(nonSpacePos, length);
    }

    public static String trimTrailing(String s) {
        int lastPos;
        int nonSpacePos;
        Validator.ensureNotNull(s);
        for (nonSpacePos = lastPos = s.length() - 1; nonSpacePos >= 0 && s.charAt(nonSpacePos) == ' '; --nonSpacePos) {
        }
        if (nonSpacePos < 0) {
            return "";
        }
        if (nonSpacePos == lastPos) {
            return s;
        }
        return s.substring(0, nonSpacePos + 1);
    }

    public static List<String> wrapLine(String line, int maxWidth) {
        ArrayList<String> lineList;
        block6: {
            String s;
            int length = line.length();
            if (maxWidth <= 0 || length < maxWidth) {
                return Arrays.asList(line);
            }
            int wrapPos = maxWidth;
            int lastWrapPos = 0;
            lineList = new ArrayList<String>(5);
            do {
                int spacePos;
                if ((spacePos = line.lastIndexOf(32, wrapPos)) > lastWrapPos) {
                    s = StaticUtils.trimTrailing(line.substring(lastWrapPos, spacePos));
                    if (s.length() > 0) {
                        lineList.add(s);
                    }
                    wrapPos = spacePos;
                } else {
                    lineList.add(line.substring(lastWrapPos, wrapPos));
                }
                while (wrapPos < length && line.charAt(wrapPos) == ' ') {
                    ++wrapPos;
                }
                lastWrapPos = wrapPos;
            } while ((wrapPos += maxWidth) < length);
            if (lastWrapPos >= length || (s = StaticUtils.trimTrailing(line.substring(lastWrapPos))).length() <= 0) break block6;
            lineList.add(s);
        }
        return lineList;
    }

    public static String cleanExampleCommandLineArgument(String s) {
        Validator.ensureNotNull(s);
        if (s.length() == 0) {
            return "\"\"";
        }
        boolean needsQuotes = false;
        StringBuilder buffer = new StringBuilder(2 * s.length() + 2);
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block5;
                }
                case '!': 
                case '\"': 
                case '$': 
                case '%': 
                case '`': 
                case '|': {
                    needsQuotes = true;
                    buffer.append('\\');
                    buffer.append(c);
                    continue block5;
                }
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '_': {
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        buffer.append(c);
                        continue block5;
                    }
                    needsQuotes = true;
                    buffer.append(c);
                }
            }
        }
        if (needsQuotes) {
            buffer.insert(0, '\"');
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static String concatenateStrings(List<String> l) {
        Validator.ensureNotNull(l);
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = l.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public static String secondsToHumanReadableDuration(long s) {
        return StaticUtils.millisToHumanReadableDuration(s * 1000L);
    }

    public static String millisToHumanReadableDuration(long m) {
        long numMinutes;
        long numHours;
        StringBuilder buffer = new StringBuilder();
        long numMillis = m;
        long numDays = numMillis / 86400000L;
        if (numDays > 0L) {
            numMillis -= numDays * 86400000L;
            if (numDays == 1L) {
                buffer.append(UtilityMessages.INFO_NUM_DAYS_SINGULAR.get(numDays));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_DAYS_PLURAL.get(numDays));
            }
        }
        if ((numHours = numMillis / 3600000L) > 0L) {
            numMillis -= numHours * 3600000L;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if (numHours == 1L) {
                buffer.append(UtilityMessages.INFO_NUM_HOURS_SINGULAR.get(numHours));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_HOURS_PLURAL.get(numHours));
            }
        }
        if ((numMinutes = numMillis / 60000L) > 0L) {
            numMillis -= numMinutes * 60000L;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if (numMinutes == 1L) {
                buffer.append(UtilityMessages.INFO_NUM_MINUTES_SINGULAR.get(numMinutes));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_MINUTES_PLURAL.get(numMinutes));
            }
        }
        if (numMillis == 1000L) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(UtilityMessages.INFO_NUM_SECONDS_SINGULAR.get(1));
        } else if (numMillis > 0L || buffer.length() == 0) {
            long numSeconds;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if ((numMillis -= (numSeconds = numMillis / 1000L) * 1000L) % 1000L != 0L) {
                double numSecondsDouble = (double)numSeconds + (double)numMillis / 1000.0;
                DecimalFormat decimalFormat = new DecimalFormat("0.000");
                buffer.append(UtilityMessages.INFO_NUM_SECONDS_WITH_DECIMAL.get(decimalFormat.format(numSecondsDouble)));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_SECONDS_PLURAL.get(numSeconds));
            }
        }
        return buffer.toString();
    }

    public static long nanosToMillis(long nanos) {
        return Math.max(0L, Math.round((double)nanos / 1000000.0));
    }

    public static long millisToNanos(long millis) {
        return Math.max(0L, millis * 1000000L);
    }

    public static byte[] encodeUUID(UUID uuid) {
        byte[] b = new byte[16];
        long mostSignificantBits = uuid.getMostSignificantBits();
        b[0] = (byte)(mostSignificantBits >> 56 & 0xFFL);
        b[1] = (byte)(mostSignificantBits >> 48 & 0xFFL);
        b[2] = (byte)(mostSignificantBits >> 40 & 0xFFL);
        b[3] = (byte)(mostSignificantBits >> 32 & 0xFFL);
        b[4] = (byte)(mostSignificantBits >> 24 & 0xFFL);
        b[5] = (byte)(mostSignificantBits >> 16 & 0xFFL);
        b[6] = (byte)(mostSignificantBits >> 8 & 0xFFL);
        b[7] = (byte)(mostSignificantBits & 0xFFL);
        long leastSignificantBits = uuid.getLeastSignificantBits();
        b[8] = (byte)(leastSignificantBits >> 56 & 0xFFL);
        b[9] = (byte)(leastSignificantBits >> 48 & 0xFFL);
        b[10] = (byte)(leastSignificantBits >> 40 & 0xFFL);
        b[11] = (byte)(leastSignificantBits >> 32 & 0xFFL);
        b[12] = (byte)(leastSignificantBits >> 24 & 0xFFL);
        b[13] = (byte)(leastSignificantBits >> 16 & 0xFFL);
        b[14] = (byte)(leastSignificantBits >> 8 & 0xFFL);
        b[15] = (byte)(leastSignificantBits & 0xFFL);
        return b;
    }

    public static UUID decodeUUID(byte[] b) throws ParseException {
        if (b.length != 16) {
            throw new ParseException(UtilityMessages.ERR_DECODE_UUID_INVALID_LENGTH.get(StaticUtils.toHex(b)), 0);
        }
        long mostSignificantBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(b[i] & 0xFF);
        }
        long leastSignificantBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(b[i] & 0xFF);
        }
        return new UUID(mostSignificantBits, leastSignificantBits);
    }
}

