/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.HashMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DereferencePolicy
implements Serializable {
    public static final DereferencePolicy NEVER = new DereferencePolicy("NEVER", 0);
    public static final DereferencePolicy SEARCHING = new DereferencePolicy("SEARCHING", 1);
    public static final DereferencePolicy FINDING = new DereferencePolicy("FINDING", 2);
    public static final DereferencePolicy ALWAYS = new DereferencePolicy("ALWAYS", 3);
    private static final HashMap<Integer, DereferencePolicy> UNDEFINED_POLICIES = new HashMap();
    private static final long serialVersionUID = 3722883359911755096L;
    private final int intValue;
    private final String name;

    private DereferencePolicy(int intValue) {
        this.intValue = intValue;
        this.name = String.valueOf(intValue);
    }

    private DereferencePolicy(String name, int intValue) {
        this.name = name;
        this.intValue = intValue;
    }

    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DereferencePolicy valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return NEVER;
            }
            case 1: {
                return SEARCHING;
            }
            case 2: {
                return FINDING;
            }
            case 3: {
                return ALWAYS;
            }
        }
        HashMap<Integer, DereferencePolicy> hashMap = UNDEFINED_POLICIES;
        synchronized (hashMap) {
            DereferencePolicy p = UNDEFINED_POLICIES.get(intValue);
            if (p == null) {
                p = new DereferencePolicy(intValue);
                UNDEFINED_POLICIES.put(intValue, p);
            }
            return p;
        }
    }

    public int hashCode() {
        return this.intValue;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof DereferencePolicy) {
            return this.intValue == ((DereferencePolicy)o).intValue;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

