/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class ExtendedRequest
extends LDAPRequest
implements ResponseAcceptor,
ProtocolOp {
    protected static final byte TYPE_EXTENDED_REQUEST_OID = -128;
    protected static final byte TYPE_EXTENDED_REQUEST_VALUE = -127;
    private static final long serialVersionUID = 5572410770060685796L;
    private final ASN1OctetString value;
    private int messageID = -1;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private final String oid;

    public ExtendedRequest(String oid) {
        super(null);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = null;
    }

    public ExtendedRequest(String oid, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = null;
    }

    public ExtendedRequest(String oid, ASN1OctetString value) {
        super(null);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = value;
    }

    public ExtendedRequest(String oid, ASN1OctetString value, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.value = value;
    }

    protected ExtendedRequest(ExtendedRequest extendedRequest) {
        super(extendedRequest.getControls());
        this.oid = extendedRequest.oid;
        this.value = extendedRequest.value;
    }

    public final String getOID() {
        return this.oid;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final byte getProtocolOpType() {
        return 119;
    }

    public final void writeTo(ASN1Buffer writer) {
        ASN1BufferSequence requestSequence = writer.beginSequence((byte)119);
        writer.addOctetString((byte)-128, this.oid);
        if (this.value != null) {
            writer.addOctetString((byte)-127, this.value.getValue());
        }
        requestSequence.end();
    }

    ASN1Element encodeProtocolOp() {
        ASN1Element[] protocolOpElements = this.value == null ? new ASN1Element[]{new ASN1OctetString(-128, this.oid)} : new ASN1Element[]{new ASN1OctetString(-128, this.oid), new ASN1OctetString(-127, this.value.getValue())};
        return new ASN1Sequence(119, protocolOpElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.processSync(connection);
        }
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        connection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse response;
            Debug.debugLDAPRequest(this);
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumExtendedRequests();
            connection.sendMessage(message);
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXTOP_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            ExtendedResult extendedResult = this.handleResponse(connection, response, requestTime);
            return extendedResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    private ExtendedResult processSync(LDAPConnection connection) throws LDAPException {
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            connection.getConnectionInternals().getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(this);
        connection.getConnectionStatistics().incrementNumExtendedRequests();
        connection.sendMessage(message);
        LDAPResponse response = connection.readResponse(this.messageID);
        return this.handleResponse(connection, response, requestTime);
    }

    private ExtendedResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_EXTENDED_CLIENT_TIMEOUT.get(waitTime, connection.getHostPort()));
        }
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String msg = ccr.getMessage();
            if (msg == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), msg));
        }
        connection.getConnectionStatistics().incrementNumExtendedResponses(System.nanoTime() - requestTime);
        return (ExtendedResult)response;
    }

    @InternalUseOnly
    public final void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public final int getLastMessageID() {
        return this.messageID;
    }

    public ExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public ExtendedRequest duplicate(Control[] controls) {
        ExtendedRequest r = new ExtendedRequest(this.oid, this.value, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    public String getExtendedRequestName() {
        return this.oid;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ExtendedRequest(oid='");
        buffer.append(this.oid);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

