/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ListenerMessages {
    ERR_CONN_CREATE_IO_EXCEPTION("An error occurred while attempting to prepare for communication with the client:  {0}"),
    ERR_CONN_EXCEPTION_IN_REQUEST_HANDLER("An unexpected error occurred while invoking the request handler to handle request {0}:  {1}"),
    ERR_CONN_INVALID_PROTOCOL_OP_TYPE("The client sent a request with an invalid protocol op type of {0}."),
    ERR_CONN_SEND_MESSAGE_EXCEPTION("An error occurred while attempting to send a response to the client:  {0}"),
    ERR_PROXY_HANDLER_SASL_NOT_SUPPORTED("The proxy request handler does not support SASL authentication.  Only simple authentication may be used.");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<ListenerMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<ListenerMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private ListenerMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            s = RESOURCE_BUNDLE.getString(this.name());
            MESSAGE_STRINGS.putIfAbsent(this, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            f = RESOURCE_BUNDLE == null ? new MessageFormat(this.defaultText) : new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            return f.format(args);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("listener");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

