/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BindRequestProtocolOp
implements ProtocolOp {
    public static final byte CRED_TYPE_SIMPLE = -128;
    public static final byte CRED_TYPE_SASL = -93;
    private static final long serialVersionUID = 6661208657485444954L;
    private final ASN1OctetString saslCredentials;
    private final ASN1OctetString simplePassword;
    private final byte credentialsType;
    private final int version;
    private final String bindDN;
    private final String saslMechanism;

    public BindRequestProtocolOp(String bindDN, String password) {
        this.bindDN = bindDN == null ? "" : bindDN;
        this.simplePassword = password == null ? new ASN1OctetString(-128) : new ASN1OctetString(-128, password);
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(String bindDN, byte[] password) {
        this.bindDN = bindDN == null ? "" : bindDN;
        this.simplePassword = password == null ? new ASN1OctetString(-128) : new ASN1OctetString(-128, password);
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(String bindDN, String saslMechanism, ASN1OctetString saslCredentials) {
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.bindDN = bindDN == null ? "" : bindDN;
        this.version = 3;
        this.credentialsType = (byte)-93;
        this.simplePassword = null;
    }

    BindRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.version = reader.readInteger();
            this.bindDN = reader.readString();
            this.credentialsType = (byte)reader.peek();
            Validator.ensureNotNull(this.bindDN);
            switch (this.credentialsType) {
                case -128: {
                    this.simplePassword = new ASN1OctetString(this.credentialsType, reader.readBytes());
                    this.saslMechanism = null;
                    this.saslCredentials = null;
                    Validator.ensureNotNull(this.bindDN);
                    break;
                }
                case -93: {
                    ASN1StreamReaderSequence saslSequence = reader.beginSequence();
                    this.saslMechanism = reader.readString();
                    Validator.ensureNotNull(this.saslMechanism);
                    this.saslCredentials = saslSequence.hasMoreElements() ? new ASN1OctetString(reader.readBytes()) : null;
                    this.simplePassword = null;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_INVALID_CRED_TYPE.get(StaticUtils.toHex(this.credentialsType)));
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public byte getCredentialsType() {
        return this.credentialsType;
    }

    public ASN1OctetString getSimplePassword() {
        return this.simplePassword;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public ASN1OctetString getSASLCredentials() {
        return this.saslCredentials;
    }

    public byte getProtocolOpType() {
        return 96;
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)96);
        buffer.addInteger(this.version);
        buffer.addOctetString(this.bindDN);
        if (this.credentialsType == -128) {
            buffer.addElement(this.simplePassword);
        } else {
            ASN1BufferSequence saslSequence = buffer.beginSequence((byte)-93);
            buffer.addOctetString(this.saslMechanism);
            if (this.saslCredentials != null) {
                buffer.addElement(this.saslCredentials);
            }
            saslSequence.end();
        }
        opSequence.end();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("BindRequestProtocolOp(version=");
        buffer.append(this.version);
        buffer.append(", bindDN='");
        buffer.append(this.bindDN);
        buffer.append("', type=");
        if (this.credentialsType == -128) {
            buffer.append("simple");
        } else {
            buffer.append("SASL, mechanism=");
            buffer.append(this.saslMechanism);
        }
        buffer.append(')');
    }
}

