/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncHelper
implements ResponseAcceptor,
IntermediateResponseListener {
    private static final long serialVersionUID = 7186731025240177443L;
    private final AsyncResultListener resultListener;
    private final byte opType;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncHelper(LDAPConnection connection, byte opType, AsyncResultListener resultListener, IntermediateResponseListener intermediateResponseListener) {
        this.resultListener = resultListener;
        this.opType = opType;
        this.intermediateResponseListener = intermediateResponseListener;
        this.connection = connection;
        this.createTime = System.nanoTime();
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        long responseTime = System.nanoTime() - this.createTime;
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get());
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(message));
        }
        switch (this.opType) {
            case 105: {
                this.connection.getConnectionStatistics().incrementNumAddResponses(responseTime);
                break;
            }
            case 107: {
                this.connection.getConnectionStatistics().incrementNumDeleteResponses(responseTime);
                break;
            }
            case 103: {
                this.connection.getConnectionStatistics().incrementNumModifyResponses(responseTime);
                break;
            }
            case 109: {
                this.connection.getConnectionStatistics().incrementNumModifyDNResponses(responseTime);
            }
        }
        LDAPResult result = (LDAPResult)response;
        this.resultListener.ldapResultReceived(new AsyncRequestID(result.getMessageID()), result);
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

