/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

final class ConnectThread
extends Thread {
    private final AtomicBoolean connected;
    private final AtomicBoolean started;
    private final AtomicReference<Socket> socket;
    private final AtomicReference<Thread> thread;
    private final AtomicReference<Throwable> exception;
    private final int port;
    private final SocketFactory socketFactory;
    private final String address;

    ConnectThread(SocketFactory socketFactory, String address, int port) {
        super("Background connect thread for " + address + ':' + port);
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.connected = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
        this.socket = new AtomicReference();
        this.thread = new AtomicReference();
        this.exception = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread.set(Thread.currentThread());
        this.started.set(true);
        try {
            this.socket.set(this.socketFactory.createSocket(this.address, this.port));
            this.connected.set(true);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            this.exception.set(t);
        }
        finally {
            this.thread.set(null);
        }
    }

    Socket getConnectedSocket(long timeoutMillis) throws LDAPException {
        while (!this.started.get()) {
            Thread.yield();
        }
        Thread t = this.thread.get();
        if (t != null) {
            try {
                t.join(timeoutMillis);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if (this.connected.get()) {
            return this.socket.get();
        }
        try {
            Socket s = this.socket.get();
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        Throwable cause = this.exception.get();
        if (cause == null) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_TIMEOUT.get(this.address, this.port, timeoutMillis));
        }
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_EXCEPTION.get(this.address, this.port, StaticUtils.getExceptionMessage(cause)), cause);
    }
}

