/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import javax.security.sasl.SaslClient;

final class SASLHelper {
    private final Control[] controls;
    private final int messageID;
    private final LDAPConnection connection;
    private final long responseTimeoutMillis;
    private final SASLBindRequest bindRequest;
    private final SaslClient saslClient;
    private final String mechanism;

    SASLHelper(SASLBindRequest bindRequest, LDAPConnection connection, String mechanism, SaslClient saslClient, Control[] controls, long responseTimeoutMillis) {
        this.bindRequest = bindRequest;
        this.connection = connection;
        this.mechanism = mechanism;
        this.saslClient = saslClient;
        this.controls = controls;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.messageID = -1;
    }

    BindResult processSASLBind() throws LDAPException {
        try {
            byte[] credBytes = null;
            try {
                if (this.saslClient.hasInitialResponse()) {
                    credBytes = this.saslClient.evaluateChallenge(new byte[0]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_INITIAL_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
            }
            ASN1OctetString saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
            BindResult bindResult = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
            if (!bindResult.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) {
                BindResult bindResult2 = bindResult;
                return bindResult2;
            }
            byte[] serverCredBytes = bindResult.getServerSASLCredentials().getValue();
            while (true) {
                try {
                    credBytes = this.saslClient.evaluateChallenge(serverCredBytes);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_SUBSEQUENT_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
                }
                saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
                bindResult = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
                if (!bindResult.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) {
                    BindResult bindResult3 = bindResult;
                    return bindResult3;
                }
                serverCredBytes = bindResult.getServerSASLCredentials().getValue();
            }
        }
        finally {
            try {
                this.saslClient.dispose();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    int getMessageID() {
        return this.messageID;
    }
}

