/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class WhoAmIExtendedResult
extends ExtendedResult {
    private static final long serialVersionUID = 7466531316632846077L;
    private final String authorizationID;

    public WhoAmIExtendedResult(ExtendedResult extendedResult) {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        this.authorizationID = value == null ? null : value.stringValue();
    }

    public WhoAmIExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, String authorizationID, Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, WhoAmIExtendedResult.encodeValue(authorizationID), responseControls);
        this.authorizationID = authorizationID;
    }

    private static ASN1OctetString encodeValue(String authorizationID) {
        if (authorizationID == null) {
            return null;
        }
        return new ASN1OctetString(authorizationID);
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_WHO_AM_I.get();
    }

    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("WhoAmIExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

