/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.util.DebugType;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Debug
implements Serializable {
    public static final String PROPERTY_DEBUG_ENABLED = "com.unboundid.ldap.sdk.debug.enabled";
    public static final String PROPERTY_INCLUDE_STACK_TRACE = "com.unboundid.ldap.sdk.debug.includeStackTrace";
    public static final String PROPERTY_DEBUG_LEVEL = "com.unboundid.ldap.sdk.debug.level";
    public static final String PROPERTY_DEBUG_TYPE = "com.unboundid.ldap.sdk.debug.type";
    public static final String LOGGER_NAME = "com.unboundid.ldap.sdk";
    private static final Logger logger = Logger.getLogger("com.unboundid.ldap.sdk");
    private static final long serialVersionUID = -6079754380415146030L;
    private static boolean debugEnabled;
    private static boolean includeStackTrace;
    private static EnumSet<DebugType> debugTypes;

    private Debug() {
    }

    public static void initialize() {
        includeStackTrace = false;
        debugEnabled = false;
        debugTypes = EnumSet.allOf(DebugType.class);
        logger.setLevel(Level.ALL);
    }

    public static void initialize(Properties properties) {
        String levelProp;
        String typesProp;
        String stackProp;
        Debug.initialize();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String enabledProp = properties.getProperty(PROPERTY_DEBUG_ENABLED);
        if (enabledProp != null && enabledProp.length() > 0) {
            if (enabledProp.equalsIgnoreCase("true")) {
                debugEnabled = true;
            } else if (enabledProp.equalsIgnoreCase("false")) {
                debugEnabled = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + enabledProp + "' for property " + PROPERTY_DEBUG_ENABLED + ".  The value must be either " + "'true' or 'false'.");
            }
        }
        if ((stackProp = properties.getProperty(PROPERTY_INCLUDE_STACK_TRACE)) != null && stackProp.length() > 0) {
            if (stackProp.equalsIgnoreCase("true")) {
                includeStackTrace = true;
            } else if (stackProp.equalsIgnoreCase("false")) {
                includeStackTrace = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + stackProp + "' for property " + PROPERTY_INCLUDE_STACK_TRACE + ".  The value must be either " + "'true' or 'false'.");
            }
        }
        if ((typesProp = properties.getProperty(PROPERTY_DEBUG_TYPE)) != null && typesProp.length() > 0) {
            debugTypes = EnumSet.noneOf(DebugType.class);
            StringTokenizer t = new StringTokenizer(typesProp, ", ");
            while (t.hasMoreTokens()) {
                String debugTypeName = t.nextToken();
                DebugType debugType = DebugType.forName(debugTypeName);
                if (debugType == null) {
                    throw new IllegalArgumentException("Invalid value '" + debugTypeName + "' for property " + PROPERTY_DEBUG_TYPE + ".  Allowed values include:  " + DebugType.getTypeNameList() + '.');
                }
                debugTypes.add(debugType);
            }
        }
        if ((levelProp = properties.getProperty(PROPERTY_DEBUG_LEVEL)) != null && levelProp.length() > 0) {
            logger.setLevel(Level.parse(levelProp));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean debugEnabled() {
        return debugEnabled;
    }

    public static boolean debugEnabled(DebugType debugType) {
        return debugEnabled && debugTypes.contains((Object)debugType);
    }

    public static void setEnabled(boolean enabled) {
        debugTypes = EnumSet.allOf(DebugType.class);
        debugEnabled = enabled;
    }

    public static void setEnabled(boolean enabled, Set<DebugType> types) {
        debugTypes = types == null || types.isEmpty() ? EnumSet.allOf(DebugType.class) : EnumSet.copyOf(types);
        debugEnabled = enabled;
    }

    public static boolean includeStackTrace() {
        return includeStackTrace;
    }

    public static void setIncludeStackTrace(boolean includeStackTrace) {
        Debug.includeStackTrace = includeStackTrace;
    }

    public static EnumSet<DebugType> getDebugTypes() {
        return debugTypes;
    }

    public static void debugException(Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            Debug.debugException(Level.WARNING, t);
        }
    }

    public static void debugException(Level l, Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("caughtException=\"");
            StaticUtils.getStackTrace(t, buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString(), t);
        }
    }

    public static void debugConnect(String h, int p) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, h, p);
        }
    }

    public static void debugConnect(Level l, String h, int p) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("connectedTo=\"");
            buffer.append(h);
            buffer.append(':');
            buffer.append(p);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugDisconnect(String h, int p, DisconnectType t, String m, Throwable c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, h, p, t, m, c);
        }
    }

    public static void debugDisconnect(Level l, String h, int p, DisconnectType t, String m, Throwable c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("disconnectedFrom=\"");
            buffer.append(h);
            buffer.append(':');
            buffer.append(p);
            buffer.append("\" disconnectType=\"");
            buffer.append(t.name());
            buffer.append('\"');
            if (m != null) {
                buffer.append("\" disconnectMessage=\"");
                buffer.append(m);
                buffer.append('\"');
            }
            if (c != null) {
                buffer.append("\" disconnectCause=\"");
                StaticUtils.getStackTrace(c, buffer);
                buffer.append('\"');
            }
            logger.log(l, buffer.toString(), c);
        }
    }

    public static void debugLDAPRequest(LDAPRequest r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, r);
        }
    }

    public static void debugLDAPRequest(Level l, LDAPRequest r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("sendingLDAPRequest=\"");
            r.toString(buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugLDAPResult(LDAPResponse r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, r);
        }
    }

    public static void debugLDAPResult(Level l, LDAPResponse r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("readLDAPResult=\"");
            r.toString(buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugASN1Write(ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, e);
        }
    }

    public static void debugASN1Write(Level l, ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("writingASN1Element=\"");
            e.toString(buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugASN1Write(ASN1Buffer b) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, b);
        }
    }

    public static void debugASN1Write(Level l, ASN1Buffer b) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("writingASN1Element=\"");
            StaticUtils.toHex(b.toByteArray(), buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugASN1Read(ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Read(Level.INFO, e);
        }
    }

    public static void debugASN1Read(Level l, ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("readASN1Element=\"");
            e.toString(buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugLDIFWrite(LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFWrite(Level.INFO, r);
        }
    }

    public static void debugLDIFWrite(Level l, LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("writingLDIFRecord=\"");
            r.toString(buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugLDIFRead(LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFRead(Level.INFO, r);
        }
    }

    public static void debugLDIFRead(Level l, LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("readLDIFRecord=\"");
            r.toString(buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugMonitor(Entry e, String m) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            Debug.debugMonitor(Level.FINE, e, m);
        }
    }

    public static void debugMonitor(Level l, Entry e, String m) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("monitorEntryDN=\"");
            buffer.append(e.getDN());
            buffer.append("\" message=\"");
            buffer.append(m);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debugCodingError(Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CODING_ERROR)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, Level.SEVERE);
            buffer.append("codingError=\"");
            StaticUtils.getStackTrace(t, buffer);
            buffer.append('\"');
            logger.log(Level.SEVERE, buffer.toString());
        }
    }

    public static void debug(Level l, DebugType t, String m) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("message=\"");
            buffer.append(m);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debug(Level l, DebugType t, String m, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("message=\"");
            buffer.append(m);
            buffer.append('\"');
            buffer.append(" exception=\"");
            StaticUtils.getStackTrace(e, buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString(), e);
        }
    }

    private static void addCommonHeader(StringBuilder buffer, Level level) {
        buffer.append("level=\"");
        buffer.append(level.getName());
        buffer.append("\" threadID=");
        buffer.append(Thread.currentThread().getId());
        buffer.append(" threadName=\"");
        buffer.append(Thread.currentThread().getName());
        if (includeStackTrace) {
            buffer.append("\" calledFrom=\"");
            boolean appended = false;
            boolean foundDebug = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                String className = e.getClassName();
                if (className.equals(Debug.class.getName())) {
                    foundDebug = true;
                    continue;
                }
                if (!foundDebug) continue;
                if (appended) {
                    buffer.append(" / ");
                }
                appended = true;
                buffer.append(e.getMethodName());
                buffer.append('(');
                buffer.append(e.getFileName());
                int lineNumber = e.getLineNumber();
                if (lineNumber > 0) {
                    buffer.append(':');
                    buffer.append(lineNumber);
                } else if (e.isNativeMethod()) {
                    buffer.append(":native");
                }
                buffer.append(')');
            }
        }
        buffer.append("\" revision=");
        buffer.append(7368L);
        buffer.append(' ');
    }

    static {
        Debug.initialize(System.getProperties());
    }
}

