/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DNArgument
extends Argument {
    private static final long serialVersionUID = 7956577383262400167L;
    private final ArrayList<DN> values;
    private final List<DN> defaultValues;

    public DNArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, (List<DN>)null);
    }

    public DNArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, DN defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public DNArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, List<DN> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList();
    }

    public List<DN> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        DN parsedDN;
        try {
            parsedDN = new DN(valueString);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new ArgumentException(ArgsMessages.ERR_DN_VALUE_NOT_DN.get(valueString, this.getIdentifierString(), le.getMessage()), le);
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        this.values.add(parsedDN);
    }

    public DN getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<DN> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    public String getStringValue() {
        DN valueDN = this.getValue();
        if (valueDN == null) {
            return null;
        }
        return valueDN.toString();
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_DN_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        return ArgsMessages.INFO_DN_CONSTRAINTS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("DNArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(this.defaultValues.get(0).toString());
            } else {
                buffer.append(", defaultValues={");
                Iterator<DN> iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next().toString());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

