/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class FileArgument
extends Argument {
    private static final long serialVersionUID = -8478637530068695898L;
    private final boolean fileMustExist;
    private final boolean mustBeDirectory;
    private final boolean mustBeFile;
    private final boolean parentMustExist;
    private final ArrayList<File> values;
    private File relativeBaseDirectory;
    private final List<File> defaultValues;

    public FileArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, false, false, false, false, null);
    }

    public FileArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, boolean fileMustExist, boolean parentMustExist, boolean mustBeFile, boolean mustBeDirectory) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory, null);
    }

    public FileArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, boolean fileMustExist, boolean parentMustExist, boolean mustBeFile, boolean mustBeDirectory, List<File> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        if (mustBeFile && mustBeDirectory) {
            throw new ArgumentException(ArgsMessages.ERR_FILE_CANNOT_BE_FILE_AND_DIRECTORY.get(this.getIdentifierString()));
        }
        this.fileMustExist = fileMustExist;
        this.parentMustExist = parentMustExist;
        this.mustBeFile = mustBeFile;
        this.mustBeDirectory = mustBeDirectory;
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList();
        this.relativeBaseDirectory = null;
    }

    public boolean fileMustExist() {
        return this.fileMustExist;
    }

    public boolean parentMustExist() {
        return this.parentMustExist;
    }

    public boolean mustBeFile() {
        return this.mustBeFile;
    }

    public boolean mustBeDirectory() {
        return this.mustBeDirectory;
    }

    public List<File> getDefaultValues() {
        return this.defaultValues;
    }

    public File getRelativeBaseDirectory() {
        return this.relativeBaseDirectory;
    }

    public void setRelativeBaseDirectory(File relativeBaseDirectory) {
        this.relativeBaseDirectory = relativeBaseDirectory;
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        File f = new File(valueString);
        if (!f.isAbsolute()) {
            f = this.relativeBaseDirectory == null ? new File(f.getAbsolutePath()) : new File(new File(this.relativeBaseDirectory, valueString).getAbsolutePath());
        }
        if (f.exists()) {
            if (this.mustBeFile && !f.isFile()) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_VALUE_NOT_FILE.get(this.getIdentifierString(), f.getAbsolutePath()));
            }
            if (this.mustBeDirectory && !f.isDirectory()) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_VALUE_NOT_DIRECTORY.get(this.getIdentifierString(), f.getAbsolutePath()));
            }
        } else {
            File parentFile;
            if (this.fileMustExist) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_DOESNT_EXIST.get(f.getAbsolutePath(), this.getIdentifierString()));
            }
            if (!(!this.parentMustExist || (parentFile = f.getParentFile()) != null && parentFile.exists() && parentFile.isDirectory())) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_PARENT_DOESNT_EXIST.get(f.getAbsolutePath(), this.getIdentifierString()));
            }
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        this.values.add(f);
    }

    public File getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<File> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileLines() throws IOException {
        File f = this.getValue();
        if (f == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNonBlankFileLines() throws IOException {
        File f = this.getValue();
        if (f == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    lines.add(line);
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileBytes() throws IOException {
        File f = this.getValue();
        if (f == null) {
            return null;
        }
        byte[] fileData = new byte[(int)f.length()];
        FileInputStream inputStream = new FileInputStream(f);
        try {
            int startPos = 0;
            int length = fileData.length;
            int bytesRead = inputStream.read(fileData, startPos, length);
            while (bytesRead > 0 && startPos < fileData.length) {
                bytesRead = inputStream.read(fileData, startPos += bytesRead, length -= bytesRead);
            }
            if (startPos < fileData.length) {
                throw new IOException(ArgsMessages.ERR_FILE_CANNOT_READ_FULLY.get(f.getAbsolutePath(), this.getIdentifierString()));
            }
            byte[] byArray = fileData;
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    public String getDataTypeName() {
        if (this.mustBeDirectory) {
            return ArgsMessages.INFO_FILE_TYPE_PATH_DIRECTORY.get();
        }
        return ArgsMessages.INFO_FILE_TYPE_PATH_FILE.get();
    }

    @Override
    public String getValueConstraints() {
        StringBuilder buffer = new StringBuilder();
        if (this.mustBeDirectory) {
            if (this.fileMustExist) {
                buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_DIR_MUST_EXIST.get());
            } else if (this.parentMustExist) {
                buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_DIR_PARENT_MUST_EXIST.get());
            } else {
                buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_DIR_MAY_EXIST.get());
            }
        } else if (this.fileMustExist) {
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_FILE_MUST_EXIST.get());
        } else if (this.parentMustExist) {
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_FILE_PARENT_MUST_EXIST.get());
        } else {
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_FILE_MAY_EXIST.get());
        }
        if (this.relativeBaseDirectory != null) {
            buffer.append("  ");
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_RELATIVE_PATH_SPECIFIED_ROOT.get(this.relativeBaseDirectory.getAbsolutePath()));
        }
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("FileArgument(");
        this.appendBasicToStringInfo(buffer);
        buffer.append(", fileMustExist=");
        buffer.append(this.fileMustExist);
        buffer.append(", parentMustExist=");
        buffer.append(this.parentMustExist);
        buffer.append(", mustBeFile=");
        buffer.append(this.mustBeFile);
        buffer.append(", mustBeDirectory=");
        buffer.append(this.mustBeDirectory);
        if (this.relativeBaseDirectory != null) {
            buffer.append(", relativeBaseDirectory='");
            buffer.append(this.relativeBaseDirectory.getAbsolutePath());
            buffer.append('\'');
        }
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(this.defaultValues.get(0).toString());
            } else {
                buffer.append(", defaultValues={");
                Iterator<File> iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next().toString());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

