/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ScopeArgument
extends Argument {
    private static final Map<String, SearchScope> SCOPE_STRINGS;
    private static final long serialVersionUID = 5962857448814911423L;
    private final AtomicReference<SearchScope> value;
    private final SearchScope defaultValue;

    public ScopeArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, valuePlaceholder, description, null);
    }

    public ScopeArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description, SearchScope defaultValue) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, 1, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        this.defaultValue = defaultValue;
        this.value = new AtomicReference();
    }

    public SearchScope getDefaultValue() {
        return this.defaultValue;
    }

    protected void addValue(String valueString) throws ArgumentException {
        SearchScope scope = SCOPE_STRINGS.get(StaticUtils.toLowerCase(valueString));
        if (scope == null) {
            throw new ArgumentException(ArgsMessages.ERR_SCOPE_VALUE_NOT_VALID.get(valueString, this.getIdentifierString()));
        }
        if (!this.value.compareAndSet(null, scope)) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
    }

    public SearchScope getValue() {
        SearchScope s = this.value.get();
        if (s == null) {
            return this.defaultValue;
        }
        return s;
    }

    protected boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String getDataTypeName() {
        return ArgsMessages.INFO_SCOPE_TYPE_NAME.get();
    }

    public String getValueConstraints() {
        return ArgsMessages.INFO_SCOPE_CONSTRAINTS.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ScopeArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValue != null) {
            buffer.append(", defaultValue='");
            switch (this.defaultValue.intValue()) {
                case 0: {
                    buffer.append("base");
                    break;
                }
                case 1: {
                    buffer.append("one");
                    break;
                }
                case 2: {
                    buffer.append("sub");
                    break;
                }
                case 3: {
                    buffer.append("subordinate");
                    break;
                }
                default: {
                    buffer.append(this.defaultValue.intValue());
                }
            }
            buffer.append('\'');
        }
        buffer.append(')');
    }

    static {
        HashMap<String, SearchScope> scopeMap = new HashMap<String, SearchScope>(20);
        scopeMap.put("base", SearchScope.BASE);
        scopeMap.put("baseobject", SearchScope.BASE);
        scopeMap.put("base-object", SearchScope.BASE);
        scopeMap.put("0", SearchScope.BASE);
        scopeMap.put("one", SearchScope.ONE);
        scopeMap.put("singlelevel", SearchScope.ONE);
        scopeMap.put("single-level", SearchScope.ONE);
        scopeMap.put("onelevel", SearchScope.ONE);
        scopeMap.put("one-level", SearchScope.ONE);
        scopeMap.put("1", SearchScope.ONE);
        scopeMap.put("sub", SearchScope.SUB);
        scopeMap.put("subtree", SearchScope.SUB);
        scopeMap.put("wholesubtree", SearchScope.SUB);
        scopeMap.put("whole-subtree", SearchScope.SUB);
        scopeMap.put("2", SearchScope.SUB);
        scopeMap.put("subord", SearchScope.SUBORDINATE_SUBTREE);
        scopeMap.put("subordinate", SearchScope.SUBORDINATE_SUBTREE);
        scopeMap.put("subordinatesubtree", SearchScope.SUBORDINATE_SUBTREE);
        scopeMap.put("subordinate-subtree", SearchScope.SUBORDINATE_SUBTREE);
        scopeMap.put("3", SearchScope.SUBORDINATE_SUBTREE);
        SCOPE_STRINGS = Collections.unmodifiableMap(scopeMap);
    }
}

