/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class AbstractConnectionPool
implements LDAPInterface {
    public abstract void close();

    public abstract boolean isClosed();

    public abstract LDAPConnection getConnection() throws LDAPException;

    public abstract void releaseConnection(LDAPConnection var1);

    public abstract void releaseDefunctConnection(LDAPConnection var1);

    public void releaseConnectionAfterException(LDAPConnection connection, LDAPException exception) {
        LDAPConnectionPoolHealthCheck healthCheck = this.getHealthCheck();
        try {
            healthCheck.ensureConnectionValidAfterException(connection, exception);
            this.releaseConnection(connection);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.releaseDefunctConnection(connection);
        }
    }

    public abstract int getCurrentAvailableConnections();

    public abstract int getMaximumAvailableConnections();

    public abstract LDAPConnectionPoolStatistics getConnectionPoolStatistics();

    public abstract String getConnectionPoolName();

    public abstract void setConnectionPoolName(String var1);

    public abstract LDAPConnectionPoolHealthCheck getHealthCheck();

    public abstract long getHealthCheckIntervalMillis();

    public abstract void setHealthCheckIntervalMillis(long var1);

    protected abstract void doHealthCheck();

    @Override
    public RootDSE getRootDSE() throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            RootDSE rootDSE = conn.getRootDSE();
            this.releaseConnection(conn);
            return rootDSE;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public Schema getSchema() throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            Schema schema = conn.getSchema();
            this.releaseConnection(conn);
            return schema;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public Schema getSchema(String entryDN) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            Schema schema = conn.getSchema(entryDN);
            this.releaseConnection(conn);
            return schema;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry getEntry(String dn) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            SearchResultEntry entry = conn.getEntry(dn);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry getEntry(String dn, String ... attributes) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            SearchResultEntry entry = conn.getEntry(dn, attributes);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult add(String dn, Attribute ... attributes) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.add(dn, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult add(String dn, Collection<Attribute> attributes) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.add(dn, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult add(Entry entry) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.add(entry);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.add(ldifLines);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPOrLDIFException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.add(addRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult add(ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.add((AddRequest)addRequest);
    }

    public BindResult bind(String bindDN, String password) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            BindResult result = conn.bind(bindDN, password);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    public BindResult bind(BindRequest bindRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            BindResult result = conn.bind(bindRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public CompareResult compare(String dn, String attributeName, String assertionValue) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            CompareResult result = conn.compare(dn, attributeName, assertionValue);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            CompareResult result = conn.compare(compareRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public CompareResult compare(ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.compare((CompareRequest)compareRequest);
    }

    @Override
    public LDAPResult delete(String dn) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.delete(dn);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.delete(deleteRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult delete(ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.delete((DeleteRequest)deleteRequest);
    }

    public ExtendedResult processExtendedOperation(String requestOID) throws LDAPException {
        if (requestOID.equals("1.3.6.1.4.1.1466.20037")) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_POOL_STARTTLS_NOT_ALLOWED.get());
        }
        LDAPConnection conn = this.getConnection();
        try {
            ExtendedResult result = conn.processExtendedOperation(requestOID);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    public ExtendedResult processExtendedOperation(String requestOID, ASN1OctetString requestValue) throws LDAPException {
        if (requestOID.equals("1.3.6.1.4.1.1466.20037")) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_POOL_STARTTLS_NOT_ALLOWED.get());
        }
        LDAPConnection conn = this.getConnection();
        try {
            ExtendedResult result = conn.processExtendedOperation(requestOID, requestValue);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    public ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        if (extendedRequest.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_POOL_STARTTLS_NOT_ALLOWED.get());
        }
        LDAPConnection conn = this.getConnection();
        try {
            ExtendedResult result = conn.processExtendedOperation(extendedRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modify(String dn, Modification mod) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modify(dn, mod);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modify(String dn, Modification ... mods) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modify(dn, mods);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modify(String dn, List<Modification> mods) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modify(dn, mods);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modify(ldifModificationLines);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPOrLDIFException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modify(modifyRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modify(ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.modify((ModifyRequest)modifyRequest);
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modifyDN(dn, newRDN, deleteOldRDN);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modifyDN(dn, newRDN, deleteOldRDN, newSuperiorDN);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            LDAPResult result = conn.modifyDN(modifyDNRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPException(t, conn);
            return null;
        }
    }

    @Override
    public LDAPResult modifyDN(ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.modifyDN((ModifyDNRequest)modifyDNRequest);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(baseDN, scope, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(baseDN, scope, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(searchResultListener, baseDN, scope, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(searchResultListener, baseDN, scope, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResult result = conn.search(searchRequest);
            this.releaseConnection(conn);
            return result;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResult search(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.search((SearchRequest)searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResultEntry entry = conn.searchForEntry(baseDN, scope, filter, attributes);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResultEntry entry = conn.searchForEntry(baseDN, scope, filter, attributes);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResultEntry entry = conn.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResultEntry entry = conn.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        try {
            SearchResultEntry entry = conn.searchForEntry(searchRequest);
            this.releaseConnection(conn);
            return entry;
        }
        catch (Throwable t) {
            this.throwLDAPSearchException(t, conn);
            return null;
        }
    }

    @Override
    public SearchResultEntry searchForEntry(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.searchForEntry((SearchRequest)searchRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LDAPResult> processRequests(List<LDAPRequest> requests, boolean continueOnError) throws LDAPException {
        ArrayList<LDAPResult> results;
        block15: {
            LDAPConnection conn;
            Validator.ensureNotNull(requests);
            Validator.ensureFalse(requests.isEmpty(), "LDAPConnectionPool.processRequests.requests must not be empty.");
            try {
                conn = this.getConnection();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPSearchException(le);
            }
            results = new ArrayList<LDAPResult>(requests.size());
            boolean isDefunct = false;
            try {
                block10: for (LDAPRequest request : requests) {
                    try {
                        LDAPResult result = request.process(conn, 1);
                        results.add(result);
                        switch (result.getResultCode().intValue()) {
                            case 0: 
                            case 5: 
                            case 6: 
                            case 16654: {
                                break;
                            }
                            default: {
                                if (!ResultCode.isConnectionUsable(result.getResultCode())) {
                                    isDefunct = true;
                                }
                                if (continueOnError) continue block10;
                                break block15;
                            }
                        }
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        results.add(new LDAPResult(request.getLastMessageID(), le.getResultCode(), le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), le.getResponseControls()));
                        if (!ResultCode.isConnectionUsable(le.getResultCode())) {
                            isDefunct = true;
                        }
                        if (continueOnError) continue;
                        break;
                    }
                }
            }
            finally {
                if (isDefunct) {
                    this.releaseDefunctConnection(conn);
                } else {
                    this.releaseConnection(conn);
                }
            }
        }
        return results;
    }

    void throwLDAPException(Throwable t, LDAPConnection conn) throws LDAPException {
        Debug.debugException(t);
        if (t instanceof LDAPException) {
            LDAPException le = (LDAPException)t;
            this.releaseConnectionAfterException(conn, le);
            throw le;
        }
        this.releaseDefunctConnection(conn);
        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
    }

    void throwLDAPOrLDIFException(Throwable t, LDAPConnection conn) throws LDAPException, LDIFException {
        Debug.debugException(t);
        if (t instanceof LDAPException) {
            LDAPException le = (LDAPException)t;
            this.releaseConnectionAfterException(conn, le);
            throw le;
        }
        if (t instanceof LDIFException) {
            this.releaseConnection(conn);
            throw (LDIFException)t;
        }
        this.releaseDefunctConnection(conn);
        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
    }

    void throwLDAPSearchException(Throwable t, LDAPConnection conn) throws LDAPSearchException {
        Debug.debugException(t);
        if (t instanceof LDAPException) {
            LDAPSearchException lse = t instanceof LDAPSearchException ? (LDAPSearchException)t : new LDAPSearchException((LDAPException)t);
            this.releaseConnectionAfterException(conn, lse);
            throw lse;
        }
        this.releaseDefunctConnection(conn);
        throw new LDAPSearchException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);
}

