/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SimpleBindRequest
extends BindRequest
implements ResponseAcceptor,
ProtocolOp {
    private static final byte CRED_TYPE_SIMPLE = -128;
    private static final ASN1OctetString NO_BIND_DN = new ASN1OctetString();
    private static final ASN1OctetString NO_PASSWORD = new ASN1OctetString(-128);
    private static final long serialVersionUID = 4725871243149974407L;
    private int messageID = -1;
    private final ASN1OctetString bindDN;
    private final ASN1OctetString password;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();

    public SimpleBindRequest() {
        this(NO_BIND_DN, NO_PASSWORD, NO_CONTROLS);
    }

    public SimpleBindRequest(String bindDN, String password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(String bindDN, byte[] password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(DN bindDN, String password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(DN bindDN, byte[] password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(String bindDN, String password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN);
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
    }

    public SimpleBindRequest(String bindDN, byte[] password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN);
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
    }

    public SimpleBindRequest(DN bindDN, String password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN.toString());
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
    }

    public SimpleBindRequest(DN bindDN, byte[] password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN.toString());
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
    }

    SimpleBindRequest(ASN1OctetString bindDN, ASN1OctetString password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN;
        this.password = password;
    }

    public String getBindDN() {
        return this.bindDN.stringValue();
    }

    public ASN1OctetString getPassword() {
        return this.password;
    }

    public byte getProtocolOpType() {
        return 96;
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence requestSequence = buffer.beginSequence((byte)96);
        buffer.addElement(VERSION_ELEMENT);
        buffer.addElement(this.bindDN);
        buffer.addElement(this.password);
        requestSequence.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.processSync(connection);
        }
        if (this.bindDN.getValue().length > 0 && this.password.getValue().length == 0 && connection.getConnectionOptions().bindWithDNRequiresPassword()) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_SIMPLE_BIND_DN_WITHOUT_PASSWORD.get());
            Debug.debugCodingError(le);
            throw le;
        }
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        connection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse response;
            Debug.debugLDAPRequest(this);
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumBindRequests();
            connection.sendMessage(message);
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            BindResult bindResult = this.handleResponse(connection, response, requestTime);
            return bindResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    private BindResult processSync(LDAPConnection connection) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            connection.getConnectionInternals().getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(this);
        connection.getConnectionStatistics().incrementNumBindRequests();
        connection.sendMessage(message);
        while ((response = connection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime);
    }

    private BindResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_BIND_CLIENT_TIMEOUT.get(waitTime, connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        return (BindResult)response;
    }

    public SimpleBindRequest getRebindRequest(String host, int port) {
        return new SimpleBindRequest(this.bindDN, this.password, this.getControls());
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getBindType() {
        return "SIMPLE";
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public SimpleBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public SimpleBindRequest duplicate(Control[] controls) {
        SimpleBindRequest bindRequest = new SimpleBindRequest(this.bindDN, this.password, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SimpleBindRequest(dn='");
        buffer.append(this.bindDN);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

