/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.examples.ModRateThread;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ValuePattern;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ModRate
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 2709717414202815822L;
    private BooleanArgument csvFormat;
    private BooleanArgument suppressErrorsArgument;
    private IntegerArgument collectionInterval;
    private IntegerArgument numIntervals;
    private IntegerArgument numThreads;
    private IntegerArgument ratePerSecond;
    private IntegerArgument valueLength;
    private IntegerArgument warmUpIntervals;
    private StringArgument attribute;
    private StringArgument characterSet;
    private StringArgument entryDN;
    private StringArgument proxyAs;
    private StringArgument timestampFormat;

    public static void main(String[] args) {
        ResultCode resultCode = ModRate.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        ModRate modRate = new ModRate(outStream, errStream);
        return modRate.runTool(args);
    }

    public ModRate(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "modrate";
    }

    @Override
    public String getToolDescription() {
        return "Perform repeated modifications against an LDAP directory server.";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The DN of the entry to modify.  It may be a simple DN or a value pattern to specify a range of DN (e.g., \"uid=user.[1-1000],ou=People,dc=example,dc=com\").  This must be provided.";
        this.entryDN = new StringArgument(Character.valueOf('b'), "entryDN", true, 1, "{dn}", description);
        parser.addArgument(this.entryDN);
        description = "The name of the attribute to modify.  Multiple attributes may be specified by providing this argument multiple times.  At least one attribute must be specified.";
        this.attribute = new StringArgument(Character.valueOf('A'), "attribute", true, 0, "{name}", description);
        parser.addArgument(this.attribute);
        description = "The length in bytes to use when generating values for the modifications.  If this is not provided, then a default length of ten bytes will be used.";
        this.valueLength = new IntegerArgument(Character.valueOf('l'), "valueLength", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 10);
        parser.addArgument(this.valueLength);
        description = "The set of characters to use to generate the values for the modifications.  It should only include ASCII characters.  If this is not provided, then a default set of lowercase alphabetic characters will be used.";
        this.characterSet = new StringArgument(Character.valueOf('C'), "characterSet", true, 1, "{chars}", description, "abcdefghijklmnopqrstuvwxyz");
        parser.addArgument(this.characterSet);
        description = "The number of threads to use to perform the modifications.  If this is not provided, a single thread will be used.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        parser.addArgument(this.numThreads);
        description = "The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used.";
        this.collectionInterval = new IntegerArgument(Character.valueOf('i'), "intervalDuration", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 5);
        parser.addArgument(this.collectionInterval);
        description = "The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted.";
        this.numIntervals = new IntegerArgument(Character.valueOf('I'), "numIntervals", true, 1, "{num}", description, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        parser.addArgument(this.numIntervals);
        description = "The target number of modifies to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If this option is not provided, then the tool will run at the maximum rate for the specified number of threads.";
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, "{modifies-per-second}", description, 1, Integer.MAX_VALUE);
        parser.addArgument(this.ratePerSecond);
        description = "The number of intervals to complete before beginning overall statistics collection.  Specifying a nonzero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results.";
        this.warmUpIntervals = new IntegerArgument(null, "warmUpIntervals", true, 1, "{num}", description, 0, Integer.MAX_VALUE, 0);
        parser.addArgument(this.warmUpIntervals);
        description = "Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included.";
        LinkedHashSet<String> allowedFormats = new LinkedHashSet<String>(3);
        allowedFormats.add("none");
        allowedFormats.add("with-date");
        allowedFormats.add("without-date");
        this.timestampFormat = new StringArgument(null, "timestampFormat", true, 1, "{format}", description, allowedFormats, "none");
        parser.addArgument(this.timestampFormat);
        description = "Indicates that the proxied authorization control (as defined in RFC 4370) should be used to request that operations be processed using an alternate authorization identity.";
        this.proxyAs = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, "{authzID}", description);
        parser.addArgument(this.proxyAs);
        description = "Indicates that information about the result codes for failed operations should not be displayed.";
        this.suppressErrorsArgument = new BooleanArgument(null, "suppressErrorResultCodes", 1, description);
        parser.addArgument(this.suppressErrorsArgument);
        description = "Generate output in CSV format rather than a display-friendly format";
        this.csvFormat = new BooleanArgument(Character.valueOf('c'), "csv", 1, description);
        parser.addArgument(this.csvFormat);
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setAutoReconnect(true);
        options.setUseSynchronousMode(true);
        return options;
    }

    @Override
    public ResultCode doToolProcessing() {
        long totalIntervals;
        boolean warmUp;
        String timeFormat;
        boolean includeTimestamp;
        ValuePattern authzIDPattern;
        ValuePattern dnPattern;
        try {
            dnPattern = new ValuePattern(this.entryDN.getValue());
        }
        catch (ParseException pe) {
            this.err("Unable to parse the entry DN value pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (this.proxyAs.isPresent()) {
            try {
                authzIDPattern = new ValuePattern(this.proxyAs.getValue());
            }
            catch (ParseException pe) {
                this.err("Unable to parse the proxied authorization pattern:  ", pe.getMessage());
                return ResultCode.PARAM_ERROR;
            }
        } else {
            authzIDPattern = null;
        }
        String[] attrs = new String[this.attribute.getValues().size()];
        this.attribute.getValues().toArray(attrs);
        byte[] charSet = StaticUtils.getBytes(this.characterSet.getValue());
        FixedRateBarrier fixedRateBarrier = null;
        if (this.ratePerSecond.isPresent()) {
            int intervalSeconds = this.collectionInterval.getValue();
            int ratePerInterval = this.ratePerSecond.getValue() * intervalSeconds;
            fixedRateBarrier = new FixedRateBarrier(1000L * (long)intervalSeconds, ratePerInterval);
        }
        if (this.timestampFormat.getValue().equalsIgnoreCase("with-date")) {
            includeTimestamp = true;
            timeFormat = "dd/MM/yyyy HH:mm:ss";
        } else if (this.timestampFormat.getValue().equalsIgnoreCase("without-date")) {
            includeTimestamp = true;
            timeFormat = "HH:mm:ss";
        } else {
            includeTimestamp = false;
            timeFormat = null;
        }
        int remainingWarmUpIntervals = this.warmUpIntervals.getValue();
        if (remainingWarmUpIntervals > 0) {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue() + (long)remainingWarmUpIntervals;
        } else {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue();
        }
        OutputFormat outputFormat = this.csvFormat.isPresent() ? OutputFormat.CSV : OutputFormat.COLUMNS;
        ColumnFormatter formatter = new ColumnFormatter(includeTimestamp, timeFormat, outputFormat, " ", new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Mods/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Avg Dur ms"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Errors/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Mods/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Avg Dur ms"));
        AtomicLong modCounter = new AtomicLong(0L);
        AtomicLong errorCounter = new AtomicLong(0L);
        AtomicLong modDurations = new AtomicLong(0L);
        ResultCodeCounter rcCounter = new ResultCodeCounter();
        long intervalMillis = 1000L * (long)this.collectionInterval.getValue().intValue();
        Random random = new Random();
        CyclicBarrier barrier = new CyclicBarrier(this.numThreads.getValue() + 1);
        ModRateThread[] threads = new ModRateThread[this.numThreads.getValue().intValue()];
        for (int i = 0; i < threads.length; ++i) {
            LDAPConnection connection;
            try {
                connection = this.getConnection();
            }
            catch (LDAPException le) {
                this.err("Unable to connect to the directory server:  ", StaticUtils.getExceptionMessage(le));
                return le.getResultCode();
            }
            threads[i] = new ModRateThread(i, connection, dnPattern, attrs, charSet, this.valueLength.getValue(), authzIDPattern, random.nextLong(), barrier, modCounter, modDurations, errorCounter, rcCounter, fixedRateBarrier);
            threads[i].start();
        }
        for (String headerLine : formatter.getHeaderLines(true)) {
            this.out(headerLine);
        }
        try {
            barrier.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        long overallStartTime = System.nanoTime();
        long nextIntervalStartTime = System.currentTimeMillis() + intervalMillis;
        boolean setOverallStartTime = false;
        long lastDuration = 0L;
        long lastNumErrors = 0L;
        long lastNumMods = 0L;
        long lastEndTime = System.nanoTime();
        for (long i = 0L; i < totalIntervals; ++i) {
            long totalDuration;
            long numErrors;
            long numMods;
            long startTimeMillis = System.currentTimeMillis();
            long sleepTimeMillis = nextIntervalStartTime - startTimeMillis;
            nextIntervalStartTime += intervalMillis;
            try {
                if (sleepTimeMillis > 0L) {
                    Thread.sleep(sleepTimeMillis);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            long endTime = System.nanoTime();
            long intervalDuration = endTime - lastEndTime;
            if (warmUp && remainingWarmUpIntervals > 0) {
                numMods = modCounter.getAndSet(0L);
                numErrors = errorCounter.getAndSet(0L);
                totalDuration = modDurations.getAndSet(0L);
            } else {
                numMods = modCounter.get();
                numErrors = errorCounter.get();
                totalDuration = modDurations.get();
            }
            long recentNumMods = numMods - lastNumMods;
            long recentNumErrors = numErrors - lastNumErrors;
            long recentDuration = totalDuration - lastDuration;
            double numSeconds = (double)intervalDuration / 1.0E9;
            double recentModRate = (double)recentNumMods / numSeconds;
            double recentErrorRate = (double)recentNumErrors / numSeconds;
            double recentAvgDuration = recentNumMods > 0L ? 1.0 * (double)recentDuration / (double)recentNumMods / 1000000.0 : 0.0;
            if (warmUp && remainingWarmUpIntervals > 0) {
                this.out(formatter.formatRow(recentModRate, recentAvgDuration, recentErrorRate, "warming up", "warming up"));
                if (--remainingWarmUpIntervals == 0) {
                    this.out("Warm-up completed.  Beginning overall statistics collection.");
                    setOverallStartTime = true;
                }
            } else {
                if (setOverallStartTime) {
                    overallStartTime = lastEndTime;
                    setOverallStartTime = false;
                }
                double numOverallSeconds = (double)(endTime - overallStartTime) / 1.0E9;
                double overallAuthRate = (double)numMods / numOverallSeconds;
                double overallAvgDuration = numMods > 0L ? 1.0 * (double)totalDuration / (double)numMods / 1000000.0 : 0.0;
                this.out(formatter.formatRow(recentModRate, recentAvgDuration, recentErrorRate, overallAuthRate, overallAvgDuration));
                lastNumMods = numMods;
                lastNumErrors = numErrors;
                lastDuration = totalDuration;
            }
            List<ObjectPair<ResultCode, Long>> rcCounts = rcCounter.getCounts(true);
            if (!this.suppressErrorsArgument.isPresent() && !rcCounts.isEmpty()) {
                this.err("\tError Results:");
                for (ObjectPair<ResultCode, Long> p : rcCounts) {
                    this.err("\t", p.getFirst().getName(), ":  ", p.getSecond());
                }
            }
            lastEndTime = endTime;
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        for (ModRateThread t : threads) {
            ResultCode r = t.stopRunning();
            if (resultCode != ResultCode.SUCCESS) continue;
            resultCode = r;
        }
        return resultCode;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--entryDN", "uid=user.[1-1000000],ou=People,dc=example,dc=com", "--attribute", "description", "--valueLength", "12", "--numThreads", "10"};
        String description = "Test modify performance by randomly selecting entries across a set of one million users located below 'ou=People,dc=example,dc=com' with ten concurrent threads and replacing the values for the description attribute with a string of 12 randomly-selected lowercase alphabetic characters.";
        examples.put(args, "Test modify performance by randomly selecting entries across a set of one million users located below 'ou=People,dc=example,dc=com' with ten concurrent threads and replacing the values for the description attribute with a string of 12 randomly-selected lowercase alphabetic characters.");
        return examples;
    }
}

