/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPListener
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AtomicLong nextConnectionID;
    private final AtomicReference<ServerSocket> serverSocket;
    private final AtomicReference<Thread> thread;
    private final ConcurrentHashMap<Long, LDAPListenerClientConnection> establishedConnections;
    private final CountDownLatch startLatch;
    private final LDAPListenerConfig config;

    public LDAPListener(LDAPListenerConfig config) {
        this.config = config.duplicate();
        this.stopRequested = new AtomicBoolean(false);
        this.nextConnectionID = new AtomicLong(0L);
        this.serverSocket = new AtomicReference<Object>(null);
        this.thread = new AtomicReference<Object>(null);
        this.startLatch = new CountDownLatch(1);
        this.establishedConnections = new ConcurrentHashMap();
        this.setName("LDAP Listener Thread (not listening");
    }

    public void startListening() throws IOException {
        ServerSocketFactory f = this.config.getServerSocketFactory();
        InetAddress a = this.config.getListenAddress();
        int p = this.config.getListenPort();
        if (a == null) {
            this.serverSocket.set(f.createServerSocket(this.config.getListenPort(), 128));
        } else {
            this.serverSocket.set(f.createServerSocket(this.config.getListenPort(), 128, a));
        }
        int receiveBufferSize = this.config.getReceiveBufferSize();
        if (receiveBufferSize > 0) {
            this.serverSocket.get().setReceiveBufferSize(receiveBufferSize);
        }
        this.setName("LDAP Listener Thread (listening on port " + this.serverSocket.get().getLocalPort() + ')');
        this.start();
        try {
            this.startLatch.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalUseOnly
    public void run() {
        Closeable s;
        this.thread.set(Thread.currentThread());
        LDAPListenerExceptionHandler exceptionHandler = this.config.getExceptionHandler();
        try {
            this.startLatch.countDown();
            while (!this.stopRequested.get()) {
                LDAPListenerClientConnection c;
                try {
                    s = this.serverSocket.get().accept();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (exceptionHandler == null) continue;
                    exceptionHandler.connectionCreationFailure(null, e);
                    continue;
                }
                try {
                    c = new LDAPListenerClientConnection(this, (Socket)s, this.config.getRequestHandler(), this.config.getExceptionHandler());
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (exceptionHandler == null) continue;
                    exceptionHandler.connectionCreationFailure((Socket)s, le);
                    continue;
                }
                this.establishedConnections.put(c.getConnectionID(), c);
                c.start();
            }
        }
        finally {
            s = this.serverSocket.getAndSet(null);
            if (s != null) {
                try {
                    ((ServerSocket)s).close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            this.serverSocket.set(null);
            this.thread.set(null);
        }
    }

    public void shutDown(boolean closeExisting) {
        Thread t;
        this.stopRequested.set(true);
        ServerSocket s = this.serverSocket.get();
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if ((t = this.thread.get()) != null) {
            while (t.isAlive()) {
                try {
                    t.join(100L);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                if (!t.isAlive()) continue;
                try {
                    t.interrupt();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (closeExisting) {
            ArrayList<LDAPListenerClientConnection> connList = new ArrayList<LDAPListenerClientConnection>(this.establishedConnections.values());
            for (LDAPListenerClientConnection c : connList) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    public InetAddress getListenAddress() {
        ServerSocket s = this.serverSocket.get();
        if (s == null) {
            return null;
        }
        return s.getInetAddress();
    }

    public int getListenPort() {
        ServerSocket s = this.serverSocket.get();
        if (s == null) {
            return -1;
        }
        return s.getLocalPort();
    }

    LDAPListenerConfig getConfig() {
        return this.config;
    }

    long nextConnectionID() {
        return this.nextConnectionID.getAndIncrement();
    }

    void connectionClosed(LDAPListenerClientConnection connection) {
        this.establishedConnections.remove(connection.getConnectionID());
    }
}

