/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.listener.IntermediateResponseTransformer;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.SearchEntryTransformer;
import com.unboundid.ldap.listener.SearchReferenceTransformer;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPListenerClientConnection
extends Thread {
    private static final Control[] EMPTY_CONTROL_ARRAY = new Control[0];
    private final ASN1Buffer asn1Buffer;
    private volatile ASN1StreamReader asn1Reader;
    private final AtomicBoolean suppressNextResponse;
    private final CopyOnWriteArrayList<IntermediateResponseTransformer> intermediateResponseTransformers;
    private final CopyOnWriteArrayList<SearchEntryTransformer> searchEntryTransformers;
    private final CopyOnWriteArrayList<SearchReferenceTransformer> searchReferenceTransformers;
    private final LDAPListener listener;
    private final LDAPListenerExceptionHandler exceptionHandler;
    private final LDAPListenerRequestHandler requestHandler;
    private final long connectionID;
    private volatile OutputStream outputStream;
    private volatile Socket socket;

    public LDAPListenerClientConnection(LDAPListener listener, Socket socket, LDAPListenerRequestHandler requestHandler, LDAPListenerExceptionHandler exceptionHandler) throws LDAPException {
        Validator.ensureNotNull(socket, requestHandler);
        this.listener = listener;
        this.socket = socket;
        this.exceptionHandler = exceptionHandler;
        this.intermediateResponseTransformers = new CopyOnWriteArrayList();
        this.searchEntryTransformers = new CopyOnWriteArrayList();
        this.searchReferenceTransformers = new CopyOnWriteArrayList();
        this.connectionID = listener == null ? -1L : listener.nextConnectionID();
        try {
            LDAPListenerConfig config = listener == null ? new LDAPListenerConfig(0, requestHandler) : listener.getConfig();
            socket.setKeepAlive(config.useKeepAlive());
            socket.setReuseAddress(config.useReuseAddress());
            socket.setSoLinger(config.useLinger(), config.getLingerTimeoutSeconds());
            socket.setTcpNoDelay(config.useTCPNoDelay());
            int sendBufferSize = config.getSendBufferSize();
            if (sendBufferSize > 0) {
                socket.setSendBufferSize(sendBufferSize);
            }
            this.asn1Reader = new ASN1StreamReader(socket.getInputStream());
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            try {
                socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_CONN_CREATE_IO_EXCEPTION.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        try {
            this.outputStream = socket.getOutputStream();
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            try {
                this.asn1Reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_CONN_CREATE_IO_EXCEPTION.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        try {
            this.requestHandler = requestHandler.newInstance(this);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            try {
                this.asn1Reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw le;
        }
        this.asn1Buffer = new ASN1Buffer();
        this.suppressNextResponse = new AtomicBoolean(false);
    }

    public synchronized void close() throws IOException {
        try {
            this.requestHandler.closeInstance();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            this.asn1Reader.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.socket.close();
    }

    void close(LDAPException le) {
        if (this.exceptionHandler == null) {
            Debug.debugException(le);
        } else {
            try {
                this.exceptionHandler.connectionTerminated(this, le);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        try {
            this.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @InternalUseOnly
    public void run() {
        try lbl-1000:
        // 2 sources

        {
            block31: {
                while (true) {
                    requestMessage = LDAPMessage.readFrom(this.asn1Reader, false);
                    if (requestMessage != null) break block31;
                    try {
                        this.close();
                    }
                    catch (IOException ioe) {
                        Debug.debugException(ioe);
                    }
                    return;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.close(le);
                    return;
                }
            }
            messageID = requestMessage.getMessageID();
            controls = requestMessage.getControls();
            switch (requestMessage.getProtocolOpType()) {
                case 80: {
                    this.requestHandler.processAbandonRequest(messageID, requestMessage.getAbandonRequestProtocolOp(), controls);
                    responseMessage = null;
                    break;
                }
                case 104: {
                    responseMessage = this.requestHandler.processAddRequest(messageID, requestMessage.getAddRequestProtocolOp(), controls);
                    break;
                }
                case 96: {
                    responseMessage = this.requestHandler.processBindRequest(messageID, requestMessage.getBindRequestProtocolOp(), controls);
                    break;
                }
                case 110: {
                    responseMessage = this.requestHandler.processCompareRequest(messageID, requestMessage.getCompareRequestProtocolOp(), controls);
                    break;
                }
                case 74: {
                    responseMessage = this.requestHandler.processDeleteRequest(messageID, requestMessage.getDeleteRequestProtocolOp(), controls);
                    break;
                }
                case 119: {
                    responseMessage = this.requestHandler.processExtendedRequest(messageID, requestMessage.getExtendedRequestProtocolOp(), controls);
                    break;
                }
                case 102: {
                    responseMessage = this.requestHandler.processModifyRequest(messageID, requestMessage.getModifyRequestProtocolOp(), controls);
                    break;
                }
                case 108: {
                    responseMessage = this.requestHandler.processModifyDNRequest(messageID, requestMessage.getModifyDNRequestProtocolOp(), controls);
                    break;
                }
                case 99: {
                    responseMessage = this.requestHandler.processSearchRequest(messageID, requestMessage.getSearchRequestProtocolOp(), controls);
                    break;
                }
                case 66: {
                    this.requestHandler.processUnbindRequest(messageID, requestMessage.getUnbindRequestProtocolOp(), controls);
                    this.close();
                    return;
                }
                default: {
                    this.close(new LDAPException(ResultCode.PROTOCOL_ERROR, ListenerMessages.ERR_CONN_INVALID_PROTOCOL_OP_TYPE.get(new Object[]{StaticUtils.toHex(requestMessage.getProtocolOpType())})));
                    return;
                }
            }
            if (responseMessage != null) {
                try {
                    this.sendMessage(responseMessage);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.close(le);
                    if (this.listener != null) {
                        this.listener.connectionClosed(this);
                    }
                    return;
                }
            }
            ** continue;
        }
        finally {
            if (this.listener != null) {
                this.listener.connectionClosed(this);
            }
        }
    }

    private synchronized void sendMessage(LDAPMessage message) throws LDAPException {
        if (this.suppressNextResponse.compareAndSet(true, false)) {
            return;
        }
        this.asn1Buffer.clear();
        try {
            message.writeTo(this.asn1Buffer);
        }
        catch (LDAPRuntimeException lre) {
            Debug.debugException(lre);
            lre.throwLDAPException();
        }
        try {
            this.asn1Buffer.writeTo(this.outputStream);
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_SEND_MESSAGE_EXCEPTION.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        finally {
            if (this.asn1Buffer.zeroBufferOnClear()) {
                this.asn1Buffer.clear();
            }
        }
    }

    public void sendSearchResultEntry(int messageID, SearchResultEntryProtocolOp protocolOp, Control ... controls) throws LDAPException {
        if (this.searchEntryTransformers.isEmpty()) {
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, controls));
        } else {
            SearchResultEntryProtocolOp op = protocolOp;
            Control[] c = controls == null ? EMPTY_CONTROL_ARRAY : controls;
            for (SearchEntryTransformer t : this.searchEntryTransformers) {
                ObjectPair<SearchResultEntryProtocolOp, Control[]> p = t.transformEntry(messageID, op, c);
                if (p == null) {
                    return;
                }
                op = p.getFirst();
                c = p.getSecond();
            }
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)op, c));
        }
    }

    public void sendSearchResultEntry(int messageID, Entry entry, Control ... controls) throws LDAPException {
        this.sendSearchResultEntry(messageID, new SearchResultEntryProtocolOp(entry.getDN(), new ArrayList<Attribute>(entry.getAttributes())), controls);
    }

    public void sendSearchResultReference(int messageID, SearchResultReferenceProtocolOp protocolOp, Control ... controls) throws LDAPException {
        if (this.searchReferenceTransformers.isEmpty()) {
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, controls));
        } else {
            SearchResultReferenceProtocolOp op = protocolOp;
            Control[] c = controls == null ? EMPTY_CONTROL_ARRAY : controls;
            for (SearchReferenceTransformer t : this.searchReferenceTransformers) {
                ObjectPair<SearchResultReferenceProtocolOp, Control[]> p = t.transformReference(messageID, op, c);
                if (p == null) {
                    return;
                }
                op = p.getFirst();
                c = p.getSecond();
            }
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)op, c));
        }
    }

    public void sendIntermediateResponse(int messageID, IntermediateResponseProtocolOp protocolOp, Control ... controls) throws LDAPException {
        if (this.intermediateResponseTransformers.isEmpty()) {
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, controls));
        } else {
            IntermediateResponseProtocolOp op = protocolOp;
            Control[] c = controls == null ? EMPTY_CONTROL_ARRAY : controls;
            for (IntermediateResponseTransformer t : this.intermediateResponseTransformers) {
                ObjectPair<IntermediateResponseProtocolOp, Control[]> p = t.transformIntermediateResponse(messageID, op, c);
                if (p == null) {
                    return;
                }
                op = p.getFirst();
                c = p.getSecond();
            }
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)op, c));
        }
    }

    public synchronized Socket getSocket() {
        return this.socket;
    }

    public synchronized OutputStream convertToTLS(SSLSocketFactory f) throws LDAPException {
        OutputStream clearOutputStream = this.outputStream;
        Socket origSocket = this.socket;
        String hostname = origSocket.getInetAddress().getHostName();
        int port = origSocket.getPort();
        try {
            this.socket = f.createSocket(this.socket, hostname, port, true);
            ((SSLSocket)this.socket).setUseClientMode(false);
            this.outputStream = this.socket.getOutputStream();
            this.asn1Reader = new ASN1StreamReader(this.socket.getInputStream());
            this.suppressNextResponse.set(true);
            return clearOutputStream;
        }
        catch (Exception e) {
            Debug.debugException(e);
            LDAPException le = new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_CONVERT_TO_TLS_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
            this.close(le);
            throw le;
        }
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    public void addSearchEntryTransformer(SearchEntryTransformer t) {
        this.searchEntryTransformers.add(t);
    }

    public void removeSearchEntryTransformer(SearchEntryTransformer t) {
        this.searchEntryTransformers.remove(t);
    }

    public void addSearchReferenceTransformer(SearchReferenceTransformer t) {
        this.searchReferenceTransformers.add(t);
    }

    public void removeSearchReferenceTransformer(SearchReferenceTransformer t) {
        this.searchReferenceTransformers.remove(t);
    }

    public void addIntermediateResponseTransformer(IntermediateResponseTransformer t) {
        this.intermediateResponseTransformers.add(t);
    }

    public void removeIntermediateResponseTransformer(IntermediateResponseTransformer t) {
        this.intermediateResponseTransformers.remove(t);
    }
}

