/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GSSAPIBindRequest
extends SASLBindRequest
implements CallbackHandler,
PrivilegedExceptionAction<Object> {
    public static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String PROPERTY_KDC_ADDRESS = "java.security.krb5.kdc";
    private static final String PROPERTY_REALM = "java.security.krb5.realm";
    private static final String PROPERTY_CONFIG_FILE = "java.security.auth.login.config";
    private static final String PROPERTY_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final AtomicReference<String> DEFAULT_CONFIG_FILE_PATH_WITH_DEBUG = new AtomicReference();
    private static final AtomicReference<String> DEFAULT_CONFIG_FILE_PATH_WITHOUT_DEBUG = new AtomicReference();
    private static final String JAAS_CLIENT_NAME = "GSSAPIBindRequest";
    private static final long serialVersionUID = 2511890818146955112L;
    private final ASN1OctetString password;
    private final AtomicReference<LDAPConnection> conn;
    private final boolean enableGSSAPIDebugging;
    private int messageID;
    private final String authenticationID;
    private final String authorizationID;
    private final String configFilePath;
    private final String kdcAddress;
    private final String servicePrincipalProtocol;
    private final String realm;

    public GSSAPIBindRequest(String authenticationID, String password) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String password, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), controls);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), controls);
    }

    public GSSAPIBindRequest(GSSAPIBindRequestProperties gssapiProperties, Control ... controls) throws LDAPException {
        super(controls);
        Validator.ensureNotNull(gssapiProperties);
        this.authenticationID = gssapiProperties.getAuthenticationID();
        this.password = gssapiProperties.getPassword();
        this.realm = gssapiProperties.getRealm();
        this.kdcAddress = gssapiProperties.getKDCAddress();
        this.servicePrincipalProtocol = gssapiProperties.getServicePrincipalProtocol();
        this.enableGSSAPIDebugging = gssapiProperties.enableGSSAPIDebugging();
        this.conn = new AtomicReference();
        this.messageID = -1;
        String authzID = gssapiProperties.getAuthorizationID();
        this.authorizationID = authzID == null ? this.authenticationID : authzID;
        String cfgPath = gssapiProperties.getConfigFilePath();
        this.configFilePath = cfgPath == null ? GSSAPIBindRequest.getDefaultConfigFilePath(this.enableGSSAPIDebugging) : cfgPath;
    }

    @Override
    public String getSASLMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getPasswordString() {
        return this.password.stringValue();
    }

    public byte[] getPasswordBytes() {
        return this.password.getValue();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getKDCAddress() {
        return this.kdcAddress;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public String getServicePrincipalProtocol() {
        return this.servicePrincipalProtocol;
    }

    public boolean enableGSSAPIDebugging() {
        return this.enableGSSAPIDebugging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultConfigFilePath(boolean enableDebug) throws LDAPException {
        try {
            String value = enableDebug ? DEFAULT_CONFIG_FILE_PATH_WITH_DEBUG.get() : DEFAULT_CONFIG_FILE_PATH_WITHOUT_DEBUG.get();
            if (value == null) {
                File f = File.createTempFile("GSSAPIBindRequest-JAAS-Config-", ".conf");
                f.deleteOnExit();
                PrintWriter w = new PrintWriter(new FileWriter(f));
                try {
                    w.println("GSSAPIBindRequest {");
                    w.print("  com.sun.security.auth.module.Krb5LoginModule required client=true useTicketCache=true");
                    if (enableDebug) {
                        w.print(" debug=true");
                    }
                    w.println(";");
                    w.println("};");
                    Object var5_5 = null;
                    w.close();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    w.close();
                    throw throwable;
                }
                if (enableDebug) {
                    if (!DEFAULT_CONFIG_FILE_PATH_WITH_DEBUG.compareAndSet(null, f.getAbsolutePath())) {
                        f.delete();
                    }
                    value = DEFAULT_CONFIG_FILE_PATH_WITH_DEBUG.get();
                } else {
                    if (!DEFAULT_CONFIG_FILE_PATH_WITHOUT_DEBUG.compareAndSet(null, f.getAbsolutePath())) {
                        f.delete();
                    }
                    value = DEFAULT_CONFIG_FILE_PATH_WITHOUT_DEBUG.get();
                }
            }
            return value;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        Throwable throwable2;
        LoginContext context;
        if (!this.conn.compareAndSet(null, connection)) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_MULTIPLE_CONCURRENT_REQUESTS.get());
        }
        System.setProperty(PROPERTY_CONFIG_FILE, this.configFilePath);
        System.setProperty(PROPERTY_SUBJECT_CREDS_ONLY, "true");
        if (this.kdcAddress != null) {
            System.setProperty(PROPERTY_KDC_ADDRESS, this.kdcAddress);
        }
        if (this.realm != null) {
            System.setProperty(PROPERTY_REALM, this.realm);
        }
        try {
            context = new LoginContext(JAAS_CLIENT_NAME, this);
            context.login();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_INITIALIZE_JAAS_CONTEXT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            BindResult e = (BindResult)Subject.doAs(context.getSubject(), this);
        }
        catch (Exception e) {
            try {
                Debug.debugException(e);
                if (!(e instanceof LDAPException)) throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
                throw (LDAPException)e;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.conn.set(null);
            }
        }
        Object var6_7 = null;
        this.conn.set(null);
        return e;
        throw throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InternalUseOnly
    public Object run() throws LDAPException {
        SaslClient saslClient;
        LDAPConnection connection = this.conn.get();
        String[] mechanisms = new String[]{GSSAPI_MECHANISM_NAME};
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("javax.security.sasl.qop", "auth");
        saslProperties.put("javax.security.sasl.server.authentication", "true");
        try {
            saslClient = Sasl.createSaslClient(mechanisms, this.authorizationID, this.servicePrincipalProtocol, connection.getConnectedAddress(), saslProperties, this);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SASLHelper helper = new SASLHelper(this, connection, GSSAPI_MECHANISM_NAME, saslClient, this.getControls(), this.getResponseTimeoutMillis(connection));
        try {
            BindResult bindResult = helper.processSASLBind();
            Object var8_8 = null;
            this.messageID = helper.getMessageID();
            return bindResult;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.messageID = helper.getMessageID();
            throw throwable;
        }
    }

    @Override
    public GSSAPIBindRequest getRebindRequest(String host, int port) {
        try {
            GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath);
            gssapiProperties.setServicePrincipalProtocol(this.servicePrincipalProtocol);
            gssapiProperties.setEnableGSSAPIDebugging(this.enableGSSAPIDebugging);
            return new GSSAPIBindRequest(gssapiProperties, this.getControls());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @InternalUseOnly
    public void handle(Callback[] callbacks) {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.stringValue().toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback) {
                if (this.realm == null) continue;
                ((RealmCallback)callback).setText(this.realm);
                continue;
            }
            if (!Debug.debugEnabled(DebugType.LDAP)) continue;
            Debug.debug(Level.WARNING, DebugType.LDAP, "Unexpected GSSAPI SASL callback of type " + callback.getClass().getName());
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public GSSAPIBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public GSSAPIBindRequest duplicate(Control[] controls) {
        try {
            GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath);
            gssapiProperties.setServicePrincipalProtocol(this.servicePrincipalProtocol);
            gssapiProperties.setEnableGSSAPIDebugging(this.enableGSSAPIDebugging);
            GSSAPIBindRequest bindRequest = new GSSAPIBindRequest(gssapiProperties, controls);
            bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
            return bindRequest;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GSSAPIBindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        if (this.kdcAddress != null) {
            buffer.append(", kdcAddress='");
            buffer.append(this.kdcAddress);
            buffer.append('\'');
        }
        buffer.append(", configFilePath='");
        buffer.append(this.configFilePath);
        buffer.append("', servicePrincipalProtocol='");
        buffer.append(this.servicePrincipalProtocol);
        buffer.append("', enableGSSAPIDebugging=");
        buffer.append(this.enableGSSAPIDebugging);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

