/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GSSAPIBindRequestProperties
implements Serializable {
    private static final long serialVersionUID = -8177334654843710502L;
    private ASN1OctetString password;
    private boolean enableGSSAPIDebugging;
    private String authenticationID;
    private String authorizationID;
    private String configFilePath;
    private String kdcAddress;
    private String servicePrincipalProtocol;
    private String realm;

    public GSSAPIBindRequestProperties(String authenticationID, String password) {
        this(authenticationID, null, new ASN1OctetString(password), null, null, null);
    }

    public GSSAPIBindRequestProperties(String authenticationID, byte[] password) {
        this(authenticationID, null, new ASN1OctetString(password), null, null, null);
    }

    GSSAPIBindRequestProperties(String authenticationID, String authorizationID, ASN1OctetString password, String realm, String kdcAddress, String configFilePath) {
        Validator.ensureNotNull(authenticationID);
        Validator.ensureNotNull(password);
        this.authenticationID = authenticationID;
        this.authorizationID = authorizationID;
        this.password = password;
        this.realm = realm;
        this.kdcAddress = kdcAddress;
        this.configFilePath = configFilePath;
        this.servicePrincipalProtocol = "ldap";
        this.enableGSSAPIDebugging = false;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public void setAuthenticationID(String authenticationID) {
        Validator.ensureNotNull(authenticationID);
        this.authenticationID = authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
    }

    public ASN1OctetString getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        Validator.ensureNotNull(password);
        this.password = new ASN1OctetString(password);
    }

    public void setPassword(byte[] password) {
        Validator.ensureNotNull(password);
        this.password = new ASN1OctetString(password);
    }

    public void setPassword(ASN1OctetString password) {
        Validator.ensureNotNull(password);
        this.password = password;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getKDCAddress() {
        return this.kdcAddress;
    }

    public void setKDCAddress(String kdcAddress) {
        this.kdcAddress = kdcAddress;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public String getServicePrincipalProtocol() {
        return this.servicePrincipalProtocol;
    }

    public void setServicePrincipalProtocol(String servicePrincipalProtocol) {
        Validator.ensureNotNull(servicePrincipalProtocol);
        this.servicePrincipalProtocol = servicePrincipalProtocol;
    }

    public boolean enableGSSAPIDebugging() {
        return this.enableGSSAPIDebugging;
    }

    public void setEnableGSSAPIDebugging(boolean enableGSSAPIDebugging) {
        this.enableGSSAPIDebugging = enableGSSAPIDebugging;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("GSSAPIBindRequestProperties(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        if (this.kdcAddress != null) {
            buffer.append(", kdcAddress='");
            buffer.append(this.kdcAddress);
            buffer.append('\'');
        }
        if (this.configFilePath != null) {
            buffer.append(", configFilePath='");
            buffer.append(this.configFilePath);
            buffer.append('\'');
        }
        buffer.append(", servicePrincipalProtocol='");
        buffer.append(this.servicePrincipalProtocol);
        buffer.append("', enableGSSAPIDebugging=");
        buffer.append(this.enableGSSAPIDebugging);
        buffer.append(')');
    }
}

