/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPConnectionStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public final class LDAPConnection
implements LDAPInterface,
ReferralConnector {
    private static final AtomicLong NEXT_CONNECTION_ID = new AtomicLong(0L);
    private static final SocketFactory DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    private AbstractConnectionPool connectionPool;
    private BindRequest lastBindRequest;
    private volatile boolean closeRequested;
    private volatile boolean unbindRequestSent;
    private volatile DisconnectType disconnectType;
    private int reconnectPort = -1;
    private volatile LDAPConnectionInternals connectionInternals;
    private LDAPConnectionOptions connectionOptions;
    private final LDAPConnectionStatistics connectionStatistics;
    private final long connectionID = NEXT_CONNECTION_ID.getAndIncrement();
    private long lastReconnectTime;
    private ReferralConnector referralConnector;
    private Schema cachedSchema;
    private SocketFactory lastUsedSocketFactory;
    private SocketFactory socketFactory;
    private StackTraceElement[] connectStackTrace;
    private String connectionName;
    private String connectionPoolName;
    private String hostPort;
    private String reconnectAddress;
    private volatile String disconnectMessage;
    private volatile Throwable disconnectCause;

    public LDAPConnection() {
        this(null, null);
    }

    public LDAPConnection(LDAPConnectionOptions connectionOptions) {
        this(null, connectionOptions);
    }

    public LDAPConnection(SocketFactory socketFactory) {
        this(socketFactory, null);
    }

    public LDAPConnection(SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this.socketFactory = socketFactory == null ? DEFAULT_SOCKET_FACTORY : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions.duplicate();
        this.connectionStatistics = new LDAPConnectionStatistics();
        this.connectionName = null;
        this.connectionPoolName = null;
        this.cachedSchema = null;
        this.referralConnector = this.connectionOptions.getReferralConnector();
        if (this.referralConnector == null) {
            this.referralConnector = this;
        }
    }

    public LDAPConnection(String host, int port) throws LDAPException {
        this(null, null, host, port);
    }

    public LDAPConnection(LDAPConnectionOptions connectionOptions, String host, int port) throws LDAPException {
        this(null, connectionOptions, host, port);
    }

    public LDAPConnection(SocketFactory socketFactory, String host, int port) throws LDAPException {
        this(socketFactory, null, host, port);
    }

    public LDAPConnection(SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, String host, int port) throws LDAPException {
        this(socketFactory, connectionOptions);
        this.connect(host, port);
    }

    public LDAPConnection(String host, int port, String bindDN, String bindPassword) throws LDAPException {
        this(null, null, host, port, bindDN, bindPassword);
    }

    public LDAPConnection(LDAPConnectionOptions connectionOptions, String host, int port, String bindDN, String bindPassword) throws LDAPException {
        this(null, connectionOptions, host, port, bindDN, bindPassword);
    }

    public LDAPConnection(SocketFactory socketFactory, String host, int port, String bindDN, String bindPassword) throws LDAPException {
        this(socketFactory, null, host, port, bindDN, bindPassword);
    }

    public LDAPConnection(SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, String host, int port, String bindDN, String bindPassword) throws LDAPException {
        this(socketFactory, connectionOptions, host, port);
        try {
            this.bind(new SimpleBindRequest(bindDN, bindPassword));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
            this.close();
            throw le;
        }
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void connect(String host, int port) throws LDAPException {
        this.connect(host, port, this.connectionOptions.getConnectTimeoutMillis());
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void connect(String host, int port, int timeout) throws LDAPException {
        Validator.ensureNotNull(host, port);
        this.hostPort = host + ':' + port;
        if (this.isConnected()) {
            this.setDisconnectInfo(DisconnectType.RECONNECT, null, null);
            this.close();
        }
        this.lastUsedSocketFactory = this.socketFactory;
        this.disconnectType = null;
        this.disconnectMessage = null;
        this.disconnectCause = null;
        this.reconnectAddress = host;
        this.reconnectPort = port;
        this.cachedSchema = null;
        this.unbindRequestSent = false;
        try {
            this.connectionStatistics.incrementNumConnects();
            this.connectionInternals = new LDAPConnectionInternals(this, this.connectionOptions, this.lastUsedSocketFactory, host, port, timeout);
            this.connectionInternals.startConnectionReader();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, e);
            this.connectionInternals = null;
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_CONNECT_ERROR.get(this.getHostPort(), StaticUtils.getExceptionMessage(e)), e);
        }
        if (this.connectionOptions.useSchema()) {
            try {
                this.cachedSchema = this.getSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public void reconnect() throws LDAPException {
        if (System.currentTimeMillis() - this.lastReconnectTime < 1000L) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_MULTIPLE_FAILURES.get());
        }
        BindRequest bindRequest = null;
        if (this.lastBindRequest != null && (bindRequest = this.lastBindRequest.getRebindRequest(this.reconnectAddress, this.reconnectPort)) == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_CANNOT_REAUTHENTICATE.get(this.getHostPort()));
        }
        this.setDisconnectInfo(DisconnectType.RECONNECT, null, null);
        this.terminate(null);
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connect(this.reconnectAddress, this.reconnectPort);
        if (bindRequest != null) {
            try {
                this.bind(bindRequest);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                this.terminate(null);
                throw le;
            }
        }
        this.lastReconnectTime = System.currentTimeMillis();
    }

    public boolean isConnected() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return false;
        }
        if (!internals.isConnected()) {
            this.setClosed();
            return false;
        }
        return true;
    }

    void convertToTLS(SSLContext sslContext) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        internals.convertToTLS(sslContext);
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(LDAPConnectionOptions connectionOptions) {
        if (connectionOptions == null) {
            this.connectionOptions = new LDAPConnectionOptions();
        } else {
            LDAPConnectionOptions newOptions = connectionOptions.duplicate();
            if (Debug.debugEnabled(DebugType.LDAP) && newOptions.useSynchronousMode() && !connectionOptions.useSynchronousMode() && this.isConnected()) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "A call to LDAPConnection.setConnectionOptions() with useSynchronousMode=true will have no effect for this connection because it is already established.  The useSynchronousMode option must be set before the connection is established to have any effect.");
            }
            this.connectionOptions = newOptions;
        }
    }

    public SocketFactory getLastUsedSocketFactory() {
        return this.lastUsedSocketFactory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory == null ? DEFAULT_SOCKET_FACTORY : socketFactory;
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        if (this.connectionPool == null) {
            this.connectionName = connectionName;
            if (this.connectionInternals != null) {
                LDAPConnectionReader reader = this.connectionInternals.getConnectionReader();
                reader.updateThreadName();
            }
        }
    }

    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    void setConnectionPoolName(String connectionPoolName) {
        this.connectionPoolName = connectionPoolName;
        if (this.connectionInternals != null) {
            LDAPConnectionReader reader = this.connectionInternals.getConnectionReader();
            reader.updateThreadName();
        }
    }

    String getHostPort() {
        if (this.hostPort == null) {
            return "";
        }
        return this.hostPort;
    }

    public String getConnectedAddress() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return null;
        }
        return internals.getHost();
    }

    public int getConnectedPort() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return -1;
        }
        return internals.getPort();
    }

    public StackTraceElement[] getConnectStackTrace() {
        return this.connectStackTrace;
    }

    void setConnectStackTrace(StackTraceElement[] connectStackTrace) {
        this.connectStackTrace = connectStackTrace;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void close() {
        this.closeRequested = true;
        this.setDisconnectInfo(DisconnectType.UNBIND, null, null);
        if (this.connectionPool == null) {
            this.terminate(null);
        } else {
            this.connectionPool.releaseDefunctConnection(this);
        }
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void close(Control[] controls) {
        this.closeRequested = true;
        this.setDisconnectInfo(DisconnectType.UNBIND, null, null);
        if (this.connectionPool == null) {
            this.terminate(controls);
        } else {
            this.connectionPool.releaseDefunctConnection(this);
        }
    }

    void terminate(Control[] controls) {
        if (this.isConnected() && !this.unbindRequestSent) {
            try {
                this.unbindRequestSent = true;
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.INFO, DebugType.LDAP, "Sending LDAP unbind request.");
                }
                this.connectionStatistics.incrementNumUnbindRequests();
                this.sendMessage(new LDAPMessage(this.nextMessageID(), (ProtocolOp)new UnbindRequestProtocolOp(), controls));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.setClosed();
    }

    boolean closeRequested() {
        return this.closeRequested;
    }

    boolean unbindRequestSent() {
        return this.unbindRequestSent;
    }

    void setConnectionPool(AbstractConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    @Override
    public RootDSE getRootDSE() throws LDAPException {
        return RootDSE.getRootDSE(this);
    }

    @Override
    public Schema getSchema() throws LDAPException {
        return Schema.getSchema(this, "");
    }

    @Override
    public Schema getSchema(String entryDN) throws LDAPException {
        return Schema.getSchema(this, entryDN);
    }

    @Override
    public SearchResultEntry getEntry(String dn) throws LDAPException {
        return this.getEntry(dn, null);
    }

    @Override
    public SearchResultEntry getEntry(String dn, String ... attributes) throws LDAPException {
        SearchResult result;
        Filter filter = Filter.createPresenceFilter("objectClass");
        try {
            SearchRequest searchRequest = new SearchRequest(dn, SearchScope.BASE, DereferencePolicy.NEVER, 1, 0, false, filter, attributes);
            result = this.search(searchRequest);
        }
        catch (LDAPException le) {
            if (le.getResultCode().equals(ResultCode.NO_SUCH_OBJECT)) {
                return null;
            }
            throw le;
        }
        if (!result.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPException(result);
        }
        List<SearchResultEntry> entryList = result.getSearchEntries();
        if (entryList.isEmpty()) {
            return null;
        }
        return entryList.get(0);
    }

    public void abandon(AsyncRequestID requestID) throws LDAPException {
        this.abandon(requestID, null);
    }

    public void abandon(AsyncRequestID requestID, Control[] controls) throws LDAPException {
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Sending LDAP abandon request for message ID " + requestID);
        }
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ABANDON_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        this.connectionStatistics.incrementNumAbandonRequests();
        this.sendMessage(new LDAPMessage(this.nextMessageID(), (ProtocolOp)new AbandonRequestProtocolOp(requestID.getMessageID()), controls));
    }

    @Override
    public LDAPResult add(String dn, Attribute ... attributes) throws LDAPException {
        Validator.ensureNotNull(dn, attributes);
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    public LDAPResult add(String dn, Collection<Attribute> attributes) throws LDAPException {
        Validator.ensureNotNull(dn, attributes);
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    public LDAPResult add(Entry entry) throws LDAPException {
        Validator.ensureNotNull(entry);
        return this.add(new AddRequest(entry));
    }

    @Override
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.add(new AddRequest(ldifLines));
    }

    @Override
    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        Validator.ensureNotNull(addRequest);
        LDAPResult ldapResult = addRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult add(ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.add((AddRequest)addRequest);
    }

    public AsyncRequestID asyncAdd(AddRequest addRequest, AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(addRequest, resultListener);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return addRequest.processAsync(this, resultListener);
    }

    public AsyncRequestID asyncAdd(ReadOnlyAddRequest addRequest, AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncAdd((AddRequest)addRequest, resultListener);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public BindResult bind(String bindDN, String password) throws LDAPException {
        return this.bind(new SimpleBindRequest(bindDN, password));
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public BindResult bind(BindRequest bindRequest) throws LDAPException {
        Validator.ensureNotNull(bindRequest);
        this.lastBindRequest = null;
        BindResult bindResult = bindRequest.process(this, 1);
        if (bindResult.getResultCode().equals(ResultCode.SUCCESS)) {
            this.lastBindRequest = bindRequest;
            if (this.connectionOptions.useSchema()) {
                try {
                    this.cachedSchema = this.getSchema();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            return bindResult;
        }
        throw new LDAPException(bindResult);
    }

    @Override
    public CompareResult compare(String dn, String attributeName, String assertionValue) throws LDAPException {
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        return this.compare(new CompareRequest(dn, attributeName, assertionValue));
    }

    @Override
    public CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        Validator.ensureNotNull(compareRequest);
        CompareResult result = compareRequest.process(this, 1);
        switch (result.getResultCode().intValue()) {
            case 5: 
            case 6: {
                return new CompareResult(result);
            }
        }
        throw new LDAPException(result);
    }

    @Override
    public CompareResult compare(ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.compare((CompareRequest)compareRequest);
    }

    public AsyncRequestID asyncCompare(CompareRequest compareRequest, AsyncCompareResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(compareRequest, resultListener);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return compareRequest.processAsync(this, resultListener);
    }

    public AsyncRequestID asyncCompare(ReadOnlyCompareRequest compareRequest, AsyncCompareResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncCompare((CompareRequest)compareRequest, resultListener);
    }

    @Override
    public LDAPResult delete(String dn) throws LDAPException {
        return this.delete(new DeleteRequest(dn));
    }

    @Override
    public LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        Validator.ensureNotNull(deleteRequest);
        LDAPResult ldapResult = deleteRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult delete(ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.delete((DeleteRequest)deleteRequest);
    }

    public AsyncRequestID asyncDelete(DeleteRequest deleteRequest, AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(deleteRequest, resultListener);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return deleteRequest.processAsync(this, resultListener);
    }

    public AsyncRequestID asyncDelete(ReadOnlyDeleteRequest deleteRequest, AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncDelete((DeleteRequest)deleteRequest, resultListener);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public ExtendedResult processExtendedOperation(String requestOID) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID));
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public ExtendedResult processExtendedOperation(String requestOID, ASN1OctetString requestValue) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID, requestValue));
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        Validator.ensureNotNull(extendedRequest);
        ExtendedResult extendedResult = extendedRequest.process(this, 1);
        if (extendedResult.getOID() == null && extendedResult.getValue() == null) {
            switch (extendedResult.getResultCode().intValue()) {
                case 1: 
                case 2: 
                case 51: 
                case 52: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: 
                case 91: {
                    throw new LDAPException(extendedResult);
                }
            }
        }
        return extendedResult;
    }

    @Override
    public LDAPResult modify(String dn, Modification mod) throws LDAPException {
        Validator.ensureNotNull(dn, mod);
        return this.modify(new ModifyRequest(dn, mod));
    }

    @Override
    public LDAPResult modify(String dn, Modification ... mods) throws LDAPException {
        Validator.ensureNotNull(dn, mods);
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    public LDAPResult modify(String dn, List<Modification> mods) throws LDAPException {
        Validator.ensureNotNull(dn, mods);
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        Validator.ensureNotNull(ldifModificationLines);
        return this.modify(new ModifyRequest(ldifModificationLines));
    }

    @Override
    public LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        Validator.ensureNotNull(modifyRequest);
        LDAPResult ldapResult = modifyRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult modify(ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.modify((ModifyRequest)modifyRequest);
    }

    public AsyncRequestID asyncModify(ModifyRequest modifyRequest, AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(modifyRequest, resultListener);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return modifyRequest.processAsync(this, resultListener);
    }

    public AsyncRequestID asyncModify(ReadOnlyModifyRequest modifyRequest, AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncModify((ModifyRequest)modifyRequest, resultListener);
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN) throws LDAPException {
        Validator.ensureNotNull(dn, newRDN);
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN));
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) throws LDAPException {
        Validator.ensureNotNull(dn, newRDN);
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN, newSuperiorDN));
    }

    @Override
    public LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        Validator.ensureNotNull(modifyDNRequest);
        LDAPResult ldapResult = modifyDNRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult modifyDN(ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.modifyDN((ModifyDNRequest)modifyDNRequest);
    }

    public AsyncRequestID asyncModifyDN(ModifyDNRequest modifyDNRequest, AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(modifyDNRequest, resultListener);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return modifyDNRequest.processAsync(this, resultListener);
    }

    public AsyncRequestID asyncModifyDN(ReadOnlyModifyDNRequest modifyDNRequest, AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncModifyDN((ModifyDNRequest)modifyDNRequest, resultListener);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(baseDN, scope, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        return this.search(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    public SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult searchResult;
        Validator.ensureNotNull(searchRequest);
        try {
            searchResult = searchRequest.process(this, 1);
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        if (!searchResult.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPSearchException(searchResult);
        }
        return searchResult;
    }

    @Override
    public SearchResult search(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.search((SearchRequest)searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        SearchRequest r;
        try {
            r = new SearchRequest(baseDN, scope, DereferencePolicy.NEVER, 1, 0, false, filter, attributes);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        return this.searchForEntry(r);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, DereferencePolicy.NEVER, 1, 0, false, filter, attributes));
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        SearchRequest r;
        try {
            r = new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        return this.searchForEntry(r);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    public SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult result;
        SearchRequest r;
        if (searchRequest.getSearchResultListener() != null || searchRequest.getSizeLimit() != 1) {
            r = new SearchRequest(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), 1, searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributes());
            r.setFollowReferrals(searchRequest.followReferralsInternal());
            r.setResponseTimeoutMillis(searchRequest.getResponseTimeoutMillis(null));
            if (searchRequest.hasControl()) {
                r.setControlsInternal(searchRequest.getControls());
            }
        } else {
            r = searchRequest;
        }
        try {
            result = this.search(r);
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            if (lse.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return null;
            }
            throw lse;
        }
        if (result.getEntryCount() == 0) {
            return null;
        }
        return result.getSearchEntries().get(0);
    }

    @Override
    public SearchResultEntry searchForEntry(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.searchForEntry((SearchRequest)searchRequest);
    }

    public AsyncRequestID asyncSearch(SearchRequest searchRequest) throws LDAPException {
        Validator.ensureNotNull(searchRequest);
        SearchResultListener searchListener = searchRequest.getSearchResultListener();
        if (searchListener == null) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_ASYNC_SEARCH_NO_LISTENER.get());
            Debug.debugCodingError(le);
            throw le;
        }
        if (!(searchListener instanceof AsyncSearchResultListener)) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_ASYNC_SEARCH_INVALID_LISTENER.get());
            Debug.debugCodingError(le);
            throw le;
        }
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return searchRequest.processAsync(this, (AsyncSearchResultListener)searchListener);
    }

    public AsyncRequestID asyncSearch(ReadOnlySearchRequest searchRequest) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncSearch((SearchRequest)searchRequest);
    }

    public LDAPResult processOperation(LDAPRequest request) throws LDAPException {
        return request.process(this, 1);
    }

    public ReferralConnector getReferralConnector() {
        if (this.referralConnector == null) {
            return this;
        }
        return this.referralConnector;
    }

    public void setReferralConnector(ReferralConnector referralConnector) {
        this.referralConnector = referralConnector == null ? this : referralConnector;
    }

    void sendMessage(LDAPMessage message) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        internals.sendMessage(message);
    }

    int nextMessageID() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return -1;
        }
        return internals.nextMessageID();
    }

    public synchronized void setDisconnectInfo(DisconnectType type, String message, Throwable cause) {
        Validator.ensureNotNull((Object)type);
        if (this.disconnectType != null) {
            return;
        }
        this.disconnectType = type;
        this.disconnectMessage = message;
        this.disconnectCause = cause;
    }

    public DisconnectType getDisconnectType() {
        return this.disconnectType;
    }

    public String getDisconnectMessage() {
        return this.disconnectMessage;
    }

    public Throwable getDisconnectCause() {
        return this.disconnectCause;
    }

    void setClosed() {
        this.connectionStatistics.incrementNumDisconnects();
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            internals.close();
            this.connectionInternals = null;
        }
        this.cachedSchema = null;
    }

    void registerResponseAcceptor(int messageID, ResponseAcceptor responseAcceptor) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        internals.registerResponseAcceptor(messageID, responseAcceptor);
    }

    void deregisterResponseAcceptor(int messageID) {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            internals.deregisterResponseAcceptor(messageID);
        }
    }

    @Override
    public LDAPConnection getReferralConnection(LDAPURL referralURL, LDAPConnection connection) throws LDAPException {
        String host = referralURL.getHost();
        int port = referralURL.getPort();
        BindRequest bindRequest = null;
        if (this.lastBindRequest != null && (bindRequest = this.lastBindRequest.getRebindRequest(host, port)) == null) {
            throw new LDAPException(ResultCode.REFERRAL, LDAPMessages.ERR_CONN_CANNOT_AUTHENTICATE_FOR_REFERRAL.get(host, port));
        }
        LDAPConnection conn = new LDAPConnection(this.socketFactory, this.connectionOptions, host, port);
        if (bindRequest != null) {
            try {
                conn.bind(bindRequest);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                conn.close();
                throw le;
            }
        }
        return conn;
    }

    BindRequest getLastBindRequest() {
        return this.lastBindRequest;
    }

    LDAPConnectionInternals getConnectionInternals() {
        return this.connectionInternals;
    }

    Schema getCachedSchema() {
        return this.cachedSchema;
    }

    public boolean synchronousMode() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return false;
        }
        return internals.synchronousMode();
    }

    LDAPResponse readResponse(int messageID) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            return internals.getConnectionReader().readResponse(messageID);
        }
        if (this.disconnectType == null) {
            return new ConnectionClosedResponse(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_READ_RESPONSE_NOT_ESTABLISHED.get());
        }
        return new ConnectionClosedResponse(this.disconnectType.getResultCode(), this.disconnectMessage);
    }

    public long getConnectTime() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            return internals.getConnectTime();
        }
        return -1L;
    }

    public LDAPConnectionStatistics getConnectionStatistics() {
        return this.connectionStatistics;
    }

    public int getActiveOperationCount() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return -1;
        }
        if (internals.synchronousMode()) {
            return -1;
        }
        return internals.getConnectionReader().getActiveOperationCount();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setDisconnectInfo(DisconnectType.CLOSED_BY_FINALIZER, null, null);
        this.terminate(null);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPConnection(");
        String name = this.connectionName;
        String poolName = this.connectionPoolName;
        if (name != null) {
            buffer.append("name='");
            buffer.append(name);
            buffer.append("', ");
        } else if (poolName != null) {
            buffer.append("poolName='");
            buffer.append(poolName);
            buffer.append("', ");
        }
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null && internals.isConnected()) {
            buffer.append("connected to ");
            buffer.append(internals.getHost());
            buffer.append(':');
            buffer.append(internals.getPort());
        } else {
            buffer.append("not connected");
        }
        buffer.append(')');
    }
}

