/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuthorizationIdentityResponseControl
extends Control
implements DecodeableControl {
    public static final String AUTHORIZATION_IDENTITY_RESPONSE_OID = "2.16.840.1.113730.3.4.15";
    private static final long serialVersionUID = -6315724175438820336L;
    private final String authorizationID;

    AuthorizationIdentityResponseControl() {
        this.authorizationID = null;
    }

    public AuthorizationIdentityResponseControl(String authorizationID) {
        super(AUTHORIZATION_IDENTITY_RESPONSE_OID, false, new ASN1OctetString(authorizationID));
        Validator.ensureNotNull(authorizationID);
        this.authorizationID = authorizationID;
    }

    public AuthorizationIdentityResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_AUTHZID_RESPONSE_NO_VALUE.get());
        }
        this.authorizationID = value.stringValue();
    }

    public AuthorizationIdentityResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new AuthorizationIdentityResponseControl(oid, isCritical, value);
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_AUTHZID_RESPONSE.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AuthorizationIdentityResponseControl(authorizationID='");
        buffer.append(this.authorizationID);
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

