/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DeleteRequest
extends UpdatableLDAPRequest
implements ReadOnlyDeleteRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = -6126029442850884239L;
    private int messageID = -1;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private String dn;

    public DeleteRequest(String dn) {
        super(null);
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public DeleteRequest(String dn, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public DeleteRequest(DN dn) {
        super(null);
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    public DeleteRequest(DN dn, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public void setDN(DN dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    public byte getProtocolOpType() {
        return 74;
    }

    public void writeTo(ASN1Buffer buffer) {
        buffer.addOctetString((byte)74, this.dn);
    }

    ASN1Element encodeProtocolOp() {
        return new ASN1OctetString(74, this.dn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LDAPResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.processSync(connection, depth);
        }
        long requestTime = System.nanoTime();
        this.processAsync(connection, null);
        try {
            LDAPResponse response;
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_DELETE_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            LDAPResult lDAPResult = this.handleResponse(connection, response, requestTime, depth);
            return lDAPResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection connection, AsyncResultListener resultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (resultListener == null) {
            asyncRequestID = null;
            connection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper helper = new AsyncHelper(connection, 107, this.messageID, resultListener, this.getIntermediateResponseListener());
            connection.registerResponseAcceptor(this.messageID, helper);
            asyncRequestID = helper.getAsyncRequestID();
        }
        try {
            Debug.debugLDAPRequest(this);
            connection.getConnectionStatistics().incrementNumDeleteRequests();
            connection.sendMessage(message);
            return asyncRequestID;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.deregisterResponseAcceptor(this.messageID);
            throw le;
        }
    }

    private LDAPResult processSync(LDAPConnection connection, int depth) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            connection.getConnectionInternals().getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(this);
        connection.getConnectionStatistics().incrementNumDeleteRequests();
        connection.sendMessage(message);
        while (true) {
            try {
                response = connection.readResponse(this.messageID);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (le.getResultCode() == ResultCode.TIMEOUT && connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                throw le;
            }
            if (!(response instanceof IntermediateResponse)) break;
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime, depth);
    }

    private LDAPResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, int depth) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            if (connection.getConnectionOptions().abandonOnTimeout()) {
                connection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_DELETE_CLIENT_TIMEOUT.get(waitTime, connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumDeleteResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_DELETE_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_DELETE_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        LDAPResult result = (LDAPResult)response;
        if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
            if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), result.getResponseControls());
            }
            return this.followReferral(result, connection, depth);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult referralResult, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : referralResult.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            DeleteRequest deleteRequest = referralURL.baseDNProvided() ? new DeleteRequest(referralURL.getBaseDN(), this.getControls()) : this;
            LDAPConnection referralConn = connection.getReferralConnector().getReferralConnection(referralURL, connection);
            try {
                LDAPResult lDAPResult = deleteRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return lDAPResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
        }
        return referralResult;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public OperationType getOperationType() {
        return OperationType.DELETE;
    }

    public DeleteRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public DeleteRequest duplicate(Control[] controls) {
        DeleteRequest r = new DeleteRequest(this.dn, controls);
        if (this.followReferralsInternal() != null) {
            r.setFollowReferrals(this.followReferralsInternal());
        }
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    public LDIFDeleteChangeRecord toLDIFChangeRecord() {
        return new LDIFDeleteChangeRecord(this);
    }

    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DeleteRequest(dn='");
        buffer.append(this.dn);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

