/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ModifyDNRequest
extends UpdatableLDAPRequest
implements ReadOnlyModifyDNRequest,
ResponseAcceptor,
ProtocolOp {
    private static final byte NEW_SUPERIOR_TYPE = -128;
    private static final long serialVersionUID = -2325552729975091008L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private boolean deleteOldRDN;
    private int messageID = -1;
    private String dn;
    private String newRDN;
    private String newSuperiorDN;

    public ModifyDNRequest(String dn, String newRDN, boolean deleteOldRDN) {
        super(null);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(DN dn, RDN newRDN, boolean deleteOldRDN) {
        super(null);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn.toString();
        this.newRDN = newRDN.toString();
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) {
        super(null);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = newSuperiorDN;
    }

    public ModifyDNRequest(DN dn, RDN newRDN, boolean deleteOldRDN, DN newSuperiorDN) {
        super(null);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn.toString();
        this.newRDN = newRDN.toString();
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = newSuperiorDN == null ? null : newSuperiorDN.toString();
    }

    public ModifyDNRequest(String dn, String newRDN, boolean deleteOldRDN, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(DN dn, RDN newRDN, boolean deleteOldRDN, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn.toString();
        this.newRDN = newRDN.toString();
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = newSuperiorDN;
    }

    public ModifyDNRequest(DN dn, RDN newRDN, boolean deleteOldRDN, DN newSuperiorDN, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, newRDN);
        this.dn = dn.toString();
        this.newRDN = newRDN.toString();
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = newSuperiorDN == null ? null : newSuperiorDN.toString();
    }

    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public void setDN(DN dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(String newRDN) {
        Validator.ensureNotNull(newRDN);
        this.newRDN = newRDN;
    }

    public void setNewRDN(RDN newRDN) {
        Validator.ensureNotNull(newRDN);
        this.newRDN = newRDN.toString();
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
    }

    public String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public void setNewSuperiorDN(String newSuperiorDN) {
        this.newSuperiorDN = newSuperiorDN;
    }

    public void setNewSuperiorDN(DN newSuperiorDN) {
        this.newSuperiorDN = newSuperiorDN == null ? null : newSuperiorDN.toString();
    }

    public byte getProtocolOpType() {
        return 108;
    }

    public void writeTo(ASN1Buffer writer) {
        ASN1BufferSequence requestSequence = writer.beginSequence((byte)108);
        writer.addOctetString(this.dn);
        writer.addOctetString(this.newRDN);
        writer.addBoolean(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            writer.addOctetString((byte)-128, this.newSuperiorDN);
        }
        requestSequence.end();
    }

    ASN1Element encodeProtocolOp() {
        ASN1Element[] protocolOpElements = this.newSuperiorDN == null ? new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN)} : new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN), new ASN1OctetString(-128, this.newSuperiorDN)};
        return new ASN1Sequence(108, protocolOpElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LDAPResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.processSync(connection, depth);
        }
        long requestTime = System.nanoTime();
        this.processAsync(connection, null);
        try {
            LDAPResponse response;
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_MODDN_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            LDAPResult lDAPResult = this.handleResponse(connection, response, requestTime, depth);
            return lDAPResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection connection, AsyncResultListener resultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (resultListener == null) {
            asyncRequestID = null;
            connection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper helper = new AsyncHelper(connection, 109, this.messageID, resultListener, this.getIntermediateResponseListener());
            connection.registerResponseAcceptor(this.messageID, helper);
            asyncRequestID = helper.getAsyncRequestID();
        }
        try {
            Debug.debugLDAPRequest(this);
            connection.getConnectionStatistics().incrementNumModifyDNRequests();
            connection.sendMessage(message);
            return asyncRequestID;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.deregisterResponseAcceptor(this.messageID);
            throw le;
        }
    }

    private LDAPResult processSync(LDAPConnection connection, int depth) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            connection.getConnectionInternals().getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(this);
        connection.getConnectionStatistics().incrementNumModifyDNRequests();
        connection.sendMessage(message);
        while (true) {
            try {
                response = connection.readResponse(this.messageID);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (le.getResultCode() == ResultCode.TIMEOUT && connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                throw le;
            }
            if (!(response instanceof IntermediateResponse)) break;
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime, depth);
    }

    private LDAPResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, int depth) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            if (connection.getConnectionOptions().abandonOnTimeout()) {
                connection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_MODIFY_DN_CLIENT_TIMEOUT.get(waitTime, connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumModifyDNResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_DN_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_DN_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        LDAPResult result = (LDAPResult)response;
        if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
            if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), result.getResponseControls());
            }
            return this.followReferral(result, connection, depth);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult referralResult, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : referralResult.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            ModifyDNRequest modifyDNRequest = referralURL.baseDNProvided() ? new ModifyDNRequest(referralURL.getBaseDN().toString(), this.newRDN, this.deleteOldRDN, this.newSuperiorDN, this.getControls()) : this;
            LDAPConnection referralConn = connection.getReferralConnector().getReferralConnection(referralURL, connection);
            try {
                LDAPResult lDAPResult = modifyDNRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return lDAPResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
        }
        return referralResult;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public OperationType getOperationType() {
        return OperationType.MODIFY_DN;
    }

    public ModifyDNRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public ModifyDNRequest duplicate(Control[] controls) {
        ModifyDNRequest r = new ModifyDNRequest(this.dn, this.newRDN, this.deleteOldRDN, this.newSuperiorDN, controls);
        if (this.followReferralsInternal() != null) {
            r.setFollowReferrals(this.followReferralsInternal());
        }
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    public LDIFModifyDNChangeRecord toLDIFChangeRecord() {
        return new LDIFModifyDNChangeRecord(this);
    }

    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("ModifyDNRequest(dn='");
        buffer.append(this.dn);
        buffer.append("', newRDN='");
        buffer.append(this.newRDN);
        buffer.append("', deleteOldRDN=");
        buffer.append(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            buffer.append(", newSuperiorDN='");
            buffer.append(this.newSuperiorDN);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

