/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.ExampleCommandLineArgument;
import com.unboundid.util.Extensible;
import com.unboundid.util.NullOutputStream;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class CommandLineTool {
    private final PrintStream out;
    private final PrintStream err;
    private BooleanArgument helpArgument = null;

    public CommandLineTool(OutputStream outStream, OutputStream errStream) {
        this.out = outStream == null ? NullOutputStream.getPrintStream() : new PrintStream(outStream);
        this.err = errStream == null ? NullOutputStream.getPrintStream() : new PrintStream(errStream);
    }

    public final ResultCode runTool(String ... args) {
        try {
            ArgumentParser parser = this.createArgumentParser();
            parser.parse(args);
            if (this.helpArgument.isPresent()) {
                this.out(parser.getUsageString(79));
                this.displayExampleUsages();
                return ResultCode.SUCCESS;
            }
            this.doExtendedArgumentValidation();
        }
        catch (ArgumentException ae) {
            Debug.debugException(ae);
            this.err(ae.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        try {
            return this.doToolProcessing();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(StaticUtils.getExceptionMessage(e));
            return ResultCode.LOCAL_ERROR;
        }
    }

    private void displayExampleUsages() {
        LinkedHashMap<String[], String> examples = this.getExampleUsages();
        if (examples == null || examples.isEmpty()) {
            return;
        }
        this.out(new Object[]{UtilityMessages.INFO_CL_TOOL_LABEL_EXAMPLES});
        for (Map.Entry<String[], String> e : examples.entrySet()) {
            this.out(new Object[0]);
            this.wrapOut(2, 79, e.getValue());
            this.out(new Object[0]);
            StringBuilder buffer = new StringBuilder();
            buffer.append("    ");
            buffer.append(this.getToolName());
            String[] args = e.getKey();
            for (int i = 0; i < args.length; ++i) {
                ExampleCommandLineArgument cleanArg;
                buffer.append(' ');
                String arg = args[i];
                if (arg.startsWith("-")) {
                    if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                        cleanArg = ExampleCommandLineArgument.getCleanArgument(args[i + 1]);
                        arg = arg + ' ' + cleanArg.getLocalForm();
                        ++i;
                    }
                } else {
                    cleanArg = ExampleCommandLineArgument.getCleanArgument(arg);
                    arg = cleanArg.getLocalForm();
                }
                if (buffer.length() + arg.length() + 2 < 79) {
                    buffer.append(arg);
                    continue;
                }
                buffer.append('\\');
                this.out(buffer.toString());
                buffer.setLength(0);
                buffer.append("         ");
                buffer.append(arg);
            }
            this.out(buffer.toString());
        }
    }

    public abstract String getToolName();

    public abstract String getToolDescription();

    public int getMaxTrailingArguments() {
        return 0;
    }

    public String getTrailingArgumentsPlaceholder() {
        return null;
    }

    public final ArgumentParser createArgumentParser() throws ArgumentException {
        ArgumentParser parser = new ArgumentParser(this.getToolName(), this.getToolDescription(), this.getMaxTrailingArguments(), this.getTrailingArgumentsPlaceholder());
        this.addToolArguments(parser);
        this.helpArgument = new BooleanArgument(Character.valueOf('H'), "help", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP.get());
        this.helpArgument.addShortIdentifier(Character.valueOf('?'));
        this.helpArgument.setUsageArgument(true);
        parser.addArgument(this.helpArgument);
        return parser;
    }

    public abstract void addToolArguments(ArgumentParser var1) throws ArgumentException;

    public void doExtendedArgumentValidation() throws ArgumentException {
    }

    public abstract ResultCode doToolProcessing();

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public LinkedHashMap<String[], String> getExampleUsages() {
        return null;
    }

    public final PrintStream getOut() {
        return this.out;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void out(Object ... msg) {
        CommandLineTool.write(this.out, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapOut(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.out, indent, wrapColumn, msg);
    }

    public final PrintStream getErr() {
        return this.err;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void err(Object ... msg) {
        CommandLineTool.write(this.err, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapErr(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.err, indent, wrapColumn, msg);
    }

    private static void write(PrintStream stream, int indent, int wrapColumn, Object ... msg) {
        StringBuilder buffer = new StringBuilder();
        for (Object o : msg) {
            buffer.append(o);
        }
        if (wrapColumn > 2) {
            if (indent > 0) {
                for (String line : StaticUtils.wrapLine(buffer.toString(), wrapColumn - indent)) {
                    for (int i = 0; i < indent; ++i) {
                        stream.print(' ');
                    }
                    stream.println(line);
                }
            } else {
                for (String line : StaticUtils.wrapLine(buffer.toString(), wrapColumn)) {
                    stream.println(line);
                }
            }
        } else {
            if (indent > 0) {
                for (int i = 0; i < indent; ++i) {
                    stream.print(' ');
                }
            }
            stream.println(buffer.toString());
        }
    }
}

