/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.PromptTrustManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class LDAPCommandLineTool
extends CommandLineTool {
    private BooleanArgument trustAll = null;
    private BooleanArgument useSSL = null;
    private BooleanArgument useStartTLS = null;
    private DNArgument bindDN = null;
    private FileArgument bindPasswordFile = null;
    private FileArgument keyStorePasswordFile = null;
    private FileArgument trustStorePasswordFile = null;
    private IntegerArgument port = null;
    private StringArgument bindPassword = null;
    private StringArgument certificateNickname = null;
    private StringArgument host = null;
    private StringArgument keyStoreFormat = null;
    private StringArgument keyStorePath = null;
    private StringArgument keyStorePassword = null;
    private StringArgument saslOption = null;
    private StringArgument trustStoreFormat = null;
    private StringArgument trustStorePath = null;
    private StringArgument trustStorePassword = null;
    private BindRequest bindRequest = null;
    private ServerSet serverSet = null;
    private SSLContext startTLSContext = null;
    private final AtomicReference<PromptTrustManager> promptTrustManager = new AtomicReference();

    public LDAPCommandLineTool(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    public final void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.host = new StringArgument(Character.valueOf('h'), "hostname", true, this.supportsMultipleServers() ? 0 : 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_HOST.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_HOST.get(), "localhost");
        parser.addArgument(this.host);
        this.port = new IntegerArgument(Character.valueOf('p'), "port", true, this.supportsMultipleServers() ? 0 : 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PORT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_PORT.get(), 1, 65535, 389);
        parser.addArgument(this.port);
        this.bindDN = new DNArgument(Character.valueOf('D'), "bindDN", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_DN.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_DN.get());
        parser.addArgument(this.bindDN);
        this.bindPassword = new StringArgument(Character.valueOf('w'), "bindPassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW.get());
        parser.addArgument(this.bindPassword);
        this.bindPasswordFile = new FileArgument(Character.valueOf('j'), "bindPasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_FILE.get(), true, true, true, false);
        parser.addArgument(this.bindPasswordFile);
        this.useSSL = new BooleanArgument(Character.valueOf('Z'), "useSSL", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_SSL.get());
        parser.addArgument(this.useSSL);
        this.useStartTLS = new BooleanArgument(Character.valueOf('q'), "useStartTLS", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_START_TLS.get());
        parser.addArgument(this.useStartTLS);
        this.trustAll = new BooleanArgument(Character.valueOf('X'), "trustAll", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_ALL.get());
        parser.addArgument(this.trustAll);
        this.keyStorePath = new StringArgument(Character.valueOf('K'), "keyStorePath", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PATH.get());
        parser.addArgument(this.keyStorePath);
        this.keyStorePassword = new StringArgument(Character.valueOf('W'), "keyStorePassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD.get());
        parser.addArgument(this.keyStorePassword);
        this.keyStorePasswordFile = new FileArgument(Character.valueOf('u'), "keyStorePasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE.get());
        parser.addArgument(this.keyStorePasswordFile);
        this.keyStoreFormat = new StringArgument(null, "keyStoreFormat", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_FORMAT.get());
        parser.addArgument(this.keyStoreFormat);
        this.trustStorePath = new StringArgument(Character.valueOf('P'), "trustStorePath", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PATH.get());
        parser.addArgument(this.trustStorePath);
        this.trustStorePassword = new StringArgument(Character.valueOf('T'), "trustStorePassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD.get());
        parser.addArgument(this.trustStorePassword);
        this.trustStorePasswordFile = new FileArgument(Character.valueOf('U'), "trustStorePasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE.get());
        parser.addArgument(this.trustStorePasswordFile);
        this.trustStoreFormat = new StringArgument(null, "trustStoreFormat", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_FORMAT.get());
        parser.addArgument(this.trustStoreFormat);
        this.certificateNickname = new StringArgument(Character.valueOf('N'), "certNickname", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_CERT_NICKNAME.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_CERT_NICKNAME.get());
        parser.addArgument(this.certificateNickname);
        this.saslOption = new StringArgument(Character.valueOf('o'), "saslOption", false, 0, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_SASL_OPTION.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_SASL_OPTION.get());
        parser.addArgument(this.saslOption);
        parser.addDependentArgumentSet(this.bindDN, this.bindPassword, this.bindPasswordFile);
        parser.addExclusiveArgumentSet(this.useSSL, this.useStartTLS, new Argument[0]);
        parser.addExclusiveArgumentSet(this.bindPassword, this.bindPasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.keyStorePassword, this.keyStorePasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.trustStorePassword, this.trustStorePasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.trustAll, this.trustStorePath, new Argument[0]);
        this.addNonLDAPArguments(parser);
    }

    public abstract void addNonLDAPArguments(ArgumentParser var1) throws ArgumentException;

    public final void doExtendedArgumentValidation() throws ArgumentException {
        if ((this.host.getValues().size() > 1 || this.port.getValues().size() > 1) && this.host.getValues().size() != this.port.getValues().size()) {
            throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_HOST_PORT_COUNT_MISMATCH.get(this.host.getLongIdentifier(), this.port.getLongIdentifier()));
        }
        this.doExtendedNonLDAPArgumentValidation();
    }

    protected boolean supportsMultipleServers() {
        return false;
    }

    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return new LDAPConnectionOptions();
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final LDAPConnection getConnection() throws LDAPException {
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        LDAPConnection connection = this.serverSet.getConnection();
        if (this.useStartTLS.isPresent()) {
            try {
                ExtendedResult extendedResult = connection.processExtendedOperation(new StartTLSExtendedRequest(this.startTLSContext));
                if (!extendedResult.getResultCode().equals(ResultCode.SUCCESS)) {
                    throw new LDAPException(extendedResult.getResultCode(), UtilityMessages.ERR_LDAP_TOOL_START_TLS_FAILED.get(extendedResult.getDiagnosticMessage()));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                connection.close();
                throw le;
            }
        }
        try {
            if (this.bindRequest != null) {
                connection.bind(this.bindRequest);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.close();
            throw le;
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final LDAPConnectionPool getConnectionPool(int initialConnections, int maxConnections) throws LDAPException {
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        StartTLSPostConnectProcessor postConnectProcessor = null;
        if (this.useStartTLS.isPresent()) {
            postConnectProcessor = new StartTLSPostConnectProcessor(this.startTLSContext);
        }
        return new LDAPConnectionPool(this.serverSet, this.bindRequest, initialConnections, maxConnections, postConnectProcessor);
    }

    public ServerSet createServerSet() throws LDAPException {
        SSLUtil sslUtil = this.createSSLUtil();
        SSLSocketFactory socketFactory = null;
        if (this.useSSL.isPresent()) {
            try {
                socketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.useStartTLS.isPresent()) {
            try {
                this.startTLSContext = sslUtil.createSSLContext();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_CONTEXT.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.host.getValues().size() == 1) {
            return new SingleServerSet(this.host.getValue(), this.port.getValue(), socketFactory, this.getConnectionOptions());
        }
        List<String> hostList = this.host.getValues();
        List<Integer> portList = this.port.getValues();
        String[] hosts = new String[hostList.size()];
        int[] ports = new int[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hostList.get(i);
            ports[i] = portList.get(i);
        }
        return new RoundRobinServerSet(hosts, ports, socketFactory, this.getConnectionOptions());
    }

    private SSLUtil createSSLUtil() throws LDAPException {
        if (this.useSSL.isPresent() || this.useStartTLS.isPresent()) {
            TrustManager trustManager;
            KeyStoreKeyManager keyManager = null;
            if (this.keyStorePath.isPresent()) {
                char[] pw = null;
                if (this.keyStorePassword.isPresent()) {
                    pw = this.keyStorePassword.getValue().toCharArray();
                } else if (this.keyStorePasswordFile.isPresent()) {
                    try {
                        pw = this.keyStorePasswordFile.getNonBlankFileLines().get(0).toCharArray();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                try {
                    keyManager = new KeyStoreKeyManager(this.keyStorePath.getValue(), pw, this.keyStoreFormat.getValue(), this.certificateNickname.getValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.trustAll.isPresent()) {
                trustManager = new TrustAllTrustManager(false);
            } else if (this.trustStorePath.isPresent()) {
                char[] pw = null;
                if (this.trustStorePassword.isPresent()) {
                    pw = this.trustStorePassword.getValue().toCharArray();
                } else if (this.trustStorePasswordFile.isPresent()) {
                    try {
                        pw = this.trustStorePasswordFile.getNonBlankFileLines().get(0).toCharArray();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                trustManager = new TrustStoreTrustManager(this.trustStorePath.getValue(), pw, this.trustStoreFormat.getValue(), true);
            } else {
                trustManager = this.promptTrustManager.get();
                if (trustManager == null) {
                    PromptTrustManager m = new PromptTrustManager();
                    this.promptTrustManager.compareAndSet(null, m);
                    trustManager = this.promptTrustManager.get();
                }
            }
            return new SSLUtil(keyManager, trustManager);
        }
        return null;
    }

    private BindRequest createBindRequest() throws LDAPException {
        String pw;
        if (this.bindPassword.isPresent()) {
            pw = this.bindPassword.getValue();
        } else if (this.bindPasswordFile.isPresent()) {
            try {
                pw = this.bindPasswordFile.getNonBlankFileLines().get(0);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else {
            pw = null;
        }
        if (this.saslOption.isPresent()) {
            String dnStr = this.bindDN.isPresent() ? this.bindDN.getValue().toString() : null;
            return SASLUtils.createBindRequest(dnStr, pw, null, this.saslOption.getValues(), new Control[0]);
        }
        if (this.bindDN.isPresent()) {
            return new SimpleBindRequest(this.bindDN.getValue(), pw);
        }
        return null;
    }
}

